/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1997 Frithjof Brestrich
                       brestrich@kde.org


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/ 

#ifndef __KVIDDATA__
#define __KVIDDATA__

#include <qobject.h>
#include <qlist.h>
#include <qstrlist.h>
#include <qstring.h>

#include "xf86vidmode.h"
#include "xf86configfile.h"

#include "kvidtunecfg.h"

struct XF86DisplaySection {
  unsigned  depth;
  unsigned  virtualX, virtualY;
  QStrList  modes;
};

typedef QList<XF86DisplaySection> XF86DisplaySectionList;
/*
struct XF86SyncRange {
  unsigned start, end; 
};
*/
struct XF86MonitorSection {
  QString identifier;
  QString vendorName;
  QString modelName;
  QList<struct XF86VidSyncRange> horizSync;
  QList<struct XF86VidSyncRange> vertRefresh;
  QList<class  XF86VidModeLine>  modeLines;
};

struct XF86DeviceSection {
  QString  identifier;
  QString  vendorName;
  QString  boardName;
  QString  chipset;
  unsigned videoRam;
};

struct tScreenSection {
  QString                driver;
  QString                device;
  QString                monitor;
  unsigned               blankTime;
  unsigned               suspendTime;
  unsigned               offTime;
  unsigned               defaultColorDepth;
  XF86DisplaySectionList resolutionList;
};


struct tDoc {
  tScreenSection     screen;
  XF86DeviceSection  device;
  XF86MonitorSection monitor;
};

class KVidData
{
  Q_OBJECT;

private:
   QString           ErrorText;

protected:
  tXF86CfgDirectoryList xf86DriverList;

  tXF86CfgDirectory  *sectionScreen;
  tXF86CfgDirectory  *sectionDevice;
  tXF86CfgDirectory  *sectionMonitor;

public:

  XF86ConfigFile  *xf86cfg;
  XF86VidMode     *xf86vid;

  KVidTuneCfg     *vidCfg;
  
  tDoc            *doc;

public:

  KVidData();
  ~KVidData();

  const QString &LastErrorText();

  bool loadConfig();
  bool storeConfig();

  bool loadXf86Config(const QString &filename); 
  bool storeXf86Config(const QString &filename);

  bool getXF86DriverList(QStrList &driverlist, QStrList &devicelist, QStrList &monitorlist);
  bool setXF86Driver(unsigned num);
  bool setXF86Card(const QString &name);
  bool setXF86Monitor(const QString &name);

  bool syncRunningWithStartup();

  QStrList getVideoModeList();

protected:
  
  void SetErrorText(const QString &txt);

// copy online data to the configuration file hold in memory
   bool updateXF86Config();   
   bool updateXF86ConfigMonitor();   
   bool updateXF86ConfigCard();   
   bool updateXF86ConfigDriver();   

private:

  bool getXF86ResolutionList(XF86DisplaySectionList &reslist);
  bool setXF86ResolutionList(tXF86CfgDirectory* root,XF86DisplaySectionList &reslist);

};

#endif /* __KVIDDATA__ */
