/**********************************************************************

	--- Qt Architect generated file ---

	File: dlgadvancedxstartup.cpp
	Last generated: Sat May 2 22:08:43 1998

 *********************************************************************/

#include <limits.h>

#include <qslider.h>
#include <kapp.h>
#include "dlgadvancedxstartup.h"


#define Inherited DlgAdvancedXStartupData

DlgAdvancedXStartup::DlgAdvancedXStartup
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
    currentDispSect = NULL;

    setCaption(klocale->translate("X startup settings"));

    combobox_colors->clear();
    combobox_colors->insertItem(klocale->translate("1 bit (black&white)"));
    combobox_colors->insertItem(klocale->translate("4 bit (16 colors)"));
    combobox_colors->insertItem(klocale->translate("8 bit (256 colors)"));
    combobox_colors->insertItem(klocale->translate("15 bit (32768 colors)"));
    combobox_colors->insertItem(klocale->translate("16 bit (65536 colors)"));
    combobox_colors->insertItem(klocale->translate("24 bit (16.8 million colors)"));
    combobox_colors->insertItem(klocale->translate("32 bit (16.8 million colors)"));

    button_up->setEnabled(FALSE);
    button_down->setEnabled(TRUE);

    slider_hres->setRange(320/stepX,2000/stepX);
    slider_hres->setTickInterval(64/stepX);
    slider_hres->setSteps(1,64/stepX);
    slider_vres->setRange(200/stepY,2000/stepY);
    slider_vres->setTickInterval(64/stepY);
    slider_vres->setSteps(1,64/stepY);

    connect( combobox_colors, SIGNAL(activated(int)), SLOT(NewColorDepth(int)) );
    connect( button_up, SIGNAL(clicked()), SLOT(UpButton()) );
    connect( button_down, SIGNAL(clicked()), SLOT(DownButton()) );
    connect( listbox_resolutionlist, SIGNAL(highlighted(int)), SLOT(NewSelection(int)) );
    connect( slider_hres, SIGNAL(valueChanged(int)), SLOT(NewVRes(int)) );
    connect( slider_vres, SIGNAL(valueChanged(int)), SLOT(NewVRes(int)) );
}

DlgAdvancedXStartup::~DlgAdvancedXStartup()
{
}

void DlgAdvancedXStartup::setDataObj(KVidData  *data)
{
    int index;

    vidData = data;
    switch ( vidData->doc->screen.defaultColorDepth ) {
        case 1:  index = 0;  break;
        case 4:  index = 1;  break;
        case 8:  index = 2;  break;
        case 15: index = 3;  break;
        case 16: index = 4;  break;
        case 24: index = 5;  break;
        case 32: index = 6;  break;
	default: index = -1; break;
    }
    combobox_colors->setCurrentItem(index); 
    NewColorDepth(index);
}

/*
void DlgAdvancedXStartup::getData(int &colordepth, XF86DisplaySectionList &list)
{
    switch ( combobox_colors->currentItem() ) {
        case 0: colordepth = 8;  break;
        case 1: colordepth = 15; break;
        case 2: colordepth = 16; break;
        case 3: colordepth = 24; break;
        case 4: colordepth = 32; break;
    }
    list = resolutionList;
}
*/
void DlgAdvancedXStartup::NewColorDepth(int index)
{
    const unsigned transTable[] = { 1, 4, 8, 15 , 16, 24 , 32 };

    listbox_resolutionlist->clear();

    if ( (index < 0) || (index >= (int)(sizeof(transTable)/sizeof(unsigned))) ) 
        return;

    XF86DisplaySection *e;
    XF86DisplaySectionList *list = &(vidData->doc->screen.resolutionList);
    for ( e=list->first(); e != 0; e=list->next() ) 
        if ( e->depth == transTable[index] ) break;

    if ( e == NULL ) return;

    vidData->doc->screen.defaultColorDepth = e->depth;

    currentDispSect = e;
    listbox_resolutionlist->insertStrList(&(currentDispSect->modes));
    listbox_resolutionlist->setCurrentItem(0);

    if ( currentDispSect->virtualX == 0 || currentDispSect->virtualY == 0 ) {
        slider_hres->setValue(slider_hres->maxValue());
        slider_vres->setValue(slider_vres->maxValue());
    } else {
        // while setValue() the values are changed to we have to save them
	// before calling setValue()
        int h = currentDispSect->virtualX/stepX;
        int v = currentDispSect->virtualY/stepY;
        slider_hres->setValue(h);
        slider_vres->setValue(v);
    }
}

void DlgAdvancedXStartup::UpButton()
{
	QString s;
	int     current;

	current = listbox_resolutionlist->currentItem();
	if ( current == 0 ) return;

	s = listbox_resolutionlist->text(current);
	listbox_resolutionlist->removeItem(current);
	listbox_resolutionlist->insertItem(s,current-1);
	listbox_resolutionlist->setCurrentItem(current-1);

	s = currentDispSect->modes.at(current);
	currentDispSect->modes.remove(current);
	currentDispSect->modes.insert(current-1,s);
}

void DlgAdvancedXStartup::DownButton()
{
	QString s;
	int     current;

	current = listbox_resolutionlist->currentItem();
	if ( current == (int)listbox_resolutionlist->count()-1 ) return;

	s = listbox_resolutionlist->text(current);
	listbox_resolutionlist->removeItem(current);
	listbox_resolutionlist->insertItem(s,current+1);
	listbox_resolutionlist->setCurrentItem(current+1);

	s = currentDispSect->modes.at(current);
	currentDispSect->modes.remove(current);
	currentDispSect->modes.insert(current+1,s);
}

void DlgAdvancedXStartup::NewSelection( int index )
{
	button_up->setEnabled(index!=0);
	button_down->setEnabled(index!=(int)listbox_resolutionlist->count()-1);
	label_startupresolution->setText(listbox_resolutionlist->text(0));
}


void DlgAdvancedXStartup::NewVRes( int value )
{
    QString s;
    int     h, v;

    if ( currentDispSect == NULL ) return;

    h = slider_hres->value();
    v = slider_vres->value();

    if ( h == slider_hres->maxValue() || v == slider_vres->maxValue() ) {
        currentDispSect->virtualX = 0;
        currentDispSect->virtualY = 0;
    } else {
        currentDispSect->virtualX = h*stepX;
        currentDispSect->virtualY = v*stepY;
    }

    if ( currentDispSect->virtualX && currentDispSect->virtualY ) {
        s.sprintf("%u x %u", currentDispSect->virtualX, currentDispSect->virtualY);
    } else {
        s = klocale->translate("AUTO");
    }
    label_desktopres->setText(s);
}

