/************************************************************************
 * kcreateinst - part of kinst package - tgzcompose.h                   *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _TGZCOMPOSE_H
#define _TGZCOMPOSE_H

#include "dirview.h"

#include <stdio.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qpushbt.h>
#include <qtoolbutton.h>
#include <qlabel.h>
#include <kfiledialog.h>
#include <kfm.h>
#include <drag.h>

class tTGZComposeDlg:public QDialog
{
  Q_OBJECT
 private:
  char tempdirname[FILENAME_MAX];
  QString TGZ_filename;
  QListView* Contents;
  QListView* DirBox;
  kcreateinstDirectory* ContentsDir;
  kcreateinstDirectory* DirBoxDir;
  QLabel* status_label;
  QLabel* Head1;
  QLabel* Head2;
  QLabel* TGZ_label;
  QLineEdit* TGZ_edit;
  QPushButton* TGZ_button;
  QPushButton* add_button;
  QPushButton* remove_button;
  QToolButton* remove2_button;
  QToolButton* newdir_button;
  QPushButton* ok_button;
  QPushButton* cancel_button;
  QPushButton* help_button;
  KFileDialog* FileSelector;
  DlgLocation* newdirdlg;
 private slots:
  void BrowsePressed();
  void add_pressed();
  void remove_pressed();
  void update_dirboxes();
  void ok_pressed();
  void cancel_pressed();
  void help_pressed();
  void newdir_pressed();
 protected:
  void resizeEvent(QResizeEvent*);
  void closeEvent(QCloseEvent *e);
 public:
  QString ComposeTGZ();
  tTGZComposeDlg(QWidget *parent, const char *name);
};

#endif

