/************************************************************************
 * kcreateinst - part of kinst package - previnstdlg.cpp                *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include "previnstdlg.h"
#include "tparams.h"
#include "locale.h"

#include <stdio.h>
#include <stdlib.h>
#include <qdialog.h>

#ifndef MIN_WIDTH
#define MIN_WIDTH 400
#endif

#ifndef MIN_HEIGHT
#define MIN_HEIGHT 150
#endif

// MOC
#include "previnstdlg.moc"

kcreateinstPrevInstDlg::kcreateinstPrevInstDlg(QWidget *parent,
					       const char *name)
  : QDialog(parent, name, true)
{
  // General properties
  setCaption(_i18n("kcreateinst - Previous Installation Detector"));
  resize(MIN_WIDTH, MIN_HEIGHT);
  setMinimumWidth(MIN_WIDTH);
  setMinimumHeight(MIN_HEIGHT);

  // Create params
  origparams = new tParams;
  newparams = new tParams;

  // Create rpmdet_label
  rpmdet_label = new QLabel(this);
  rpmdet_label->setText(_i18n("RPM Detection"));
  rpmdet_label->show();

  // Create rpmdet_edit
  rpmdet_edit = new QLineEdit(this);
  rpmdet_edit->setText("");
  rpmdet_edit->show();

  // Create cancel_button
  cancel_button = new QPushButton(this);
  cancel_button->setText(_i18n("Cancel"));
  cancel_button->show();
  connect(cancel_button, SIGNAL(clicked()), SLOT(cancel_pressed()));

  // Create ok button
  ok_button = new QPushButton(this);
  ok_button->setText(_i18n("OK"));
  ok_button->show();
  connect(ok_button, SIGNAL(clicked()), SLOT(ok_pressed()));

  // Create filedet_label
  filedet_label = new QLabel(this);
  filedet_label->setText(_i18n("File Detection"));
  filedet_label->show();

  // Create filedet_edit
  filedet_edit = new QLineEdit(this);
  filedet_edit->setText("");
  filedet_edit->show();
}

void kcreateinstPrevInstDlg::resizeEvent(QResizeEvent*)
{
  // Resize rpmdet_label
  rpmdet_label->setGeometry(10,
			    10,
			    width()-20,
			    15);

  // Resize rpmdet_edit
  rpmdet_edit->setGeometry(10,
			   27,
			   width()-20,
			   20);

  // Resize cancel_button
  cancel_button->setGeometry(width()-100,
			     height()-35,
			     90,
			     30);

  // Resize ok button
  ok_button->setGeometry(10,
			 height()-35,
			 90,
			 30);

  // Resize filedet_label
  filedet_label->setGeometry(10,
			     rpmdet_label->y()+
			     rpmdet_label->height()+35,
			     width()-20,
			     15);
  // Resize filedet_edit
  filedet_edit->setGeometry(10,
			    rpmdet_edit->y()+
			    rpmdet_edit->height()+30,
			    width()-20,
			    20);
}

void kcreateinstPrevInstDlg::closeEvent(QCloseEvent *e)
{
  e->ignore();
}

void kcreateinstPrevInstDlg::getDetectionPrefs(tParams* actprefs)
{
  qstrcpy(origparams->KIFOptions.CheckPriorFile,
	  actprefs->KIFOptions.CheckPriorFile);
  qstrcpy(origparams->KIFOptions.CheckPriorRPM,
	  actprefs->KIFOptions.CheckPriorRPM);
  qstrcpy(newparams->KIFOptions.CheckPriorFile,
	  actprefs->KIFOptions.CheckPriorFile);
  qstrcpy(newparams->KIFOptions.CheckPriorRPM,
	  actprefs->KIFOptions.CheckPriorRPM);

  filedet_edit->setText(newparams->KIFOptions.CheckPriorFile);
  rpmdet_edit->setText(newparams->KIFOptions.CheckPriorRPM);

  show();

  qstrcpy(actprefs->KIFOptions.CheckPriorFile,
	  origparams->KIFOptions.CheckPriorFile);
  qstrcpy(actprefs->KIFOptions.CheckPriorRPM,
	  origparams->KIFOptions.CheckPriorRPM);
}

void kcreateinstPrevInstDlg::ok_pressed()
{
  qstrncpy(newparams->KIFOptions.CheckPriorFile, filedet_edit->text(), 1024);
  qstrncpy(newparams->KIFOptions.CheckPriorRPM, rpmdet_edit->text(), 1024);

  qstrcpy(origparams->KIFOptions.CheckPriorFile,
	  newparams->KIFOptions.CheckPriorFile);
  qstrcpy(origparams->KIFOptions.CheckPriorRPM,
	  newparams->KIFOptions.CheckPriorRPM);

  hide();
}

void kcreateinstPrevInstDlg::cancel_pressed()
{
  hide();
}

