/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import jakarta.el.ValueExpression;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.myfaces.tobago.application.LabelValueExpressionFacesMessage;

public final class MessageUtils {
    private static final String DETAIL_SUFFIX = "_detail";

    private MessageUtils() {
    }

    @Deprecated
    public static void addMessage(FacesContext facesContext, UIComponent component, FacesMessage.Severity severity, String messageId, Object[] args) {
        facesContext.addMessage(component != null ? component.getClientId(facesContext) : null, MessageUtils.getMessage(facesContext, severity, messageId, args));
    }

    public static FacesMessage getMessage(FacesContext facesContext, FacesMessage.Severity severity, String messageId, Object ... args) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Locale locale = viewRoot != null ? viewRoot.getLocale() : null;
        return MessageUtils.getMessage(facesContext, locale, severity, messageId, args);
    }

    @Deprecated
    public static FacesMessage getMessage(FacesContext facesContext, Locale locale, FacesMessage.Severity severity, String messageId, Object ... args) {
        ResourceBundle appBundle = MessageUtils.getApplicationBundle(facesContext, locale);
        String summary = MessageUtils.getBundleString(appBundle, messageId);
        String detail = MessageUtils.getBundleString(appBundle, messageId + DETAIL_SUFFIX);
        if (summary == null || detail == null) {
            ResourceBundle tobagoMessages = ResourceBundle.getBundle("org.apache.myfaces.tobago.context.TobagoMessageBundle", locale);
            if (summary == null) {
                summary = MessageUtils.getBundleString(tobagoMessages, messageId);
            }
            if (detail == null) {
                detail = MessageUtils.getBundleString(tobagoMessages, messageId + DETAIL_SUFFIX);
            }
            if (summary == null || detail == null) {
                ResourceBundle tobagoBundle = ResourceBundle.getBundle("org.apache.myfaces.tobago.context.TobagoResourceBundle", locale);
                if (summary == null) {
                    summary = MessageUtils.getBundleString(tobagoBundle, messageId);
                }
                if (detail == null) {
                    detail = MessageUtils.getBundleString(tobagoBundle, messageId + DETAIL_SUFFIX);
                }
                if (summary == null || detail == null) {
                    ResourceBundle defBundle = MessageUtils.getDefaultBundle(facesContext, locale);
                    if (summary == null) {
                        summary = MessageUtils.getBundleString(defBundle, messageId);
                    }
                    if (detail == null) {
                        detail = MessageUtils.getBundleString(defBundle, messageId + DETAIL_SUFFIX);
                    }
                }
            }
        }
        if (summary == null && detail == null) {
            facesContext.getExternalContext().log("No message with id " + messageId + " found in any bundle");
            return new FacesMessage(severity, messageId, null);
        }
        if (args != null && args.length > 0) {
            MessageFormat format;
            if (summary != null) {
                format = new MessageFormat(summary, locale);
                summary = format.format(args);
            }
            if (detail != null) {
                format = new MessageFormat(detail, locale);
                detail = format.format(args);
            }
        }
        return new LabelValueExpressionFacesMessage(severity, summary, detail);
    }

    private static String getBundleString(ResourceBundle bundle, String key) {
        try {
            return bundle == null ? null : bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static ResourceBundle getApplicationBundle(FacesContext facesContext, Locale locale) {
        String bundleName = facesContext.getApplication().getMessageBundle();
        return bundleName != null ? MessageUtils.getBundle(facesContext, locale, bundleName) : null;
    }

    private static ResourceBundle getDefaultBundle(FacesContext facesContext, Locale locale) {
        return MessageUtils.getBundle(facesContext, locale, "jakarta.faces.Messages");
    }

    private static ResourceBundle getBundle(FacesContext facesContext, Locale locale, String bundleName) {
        try {
            return ResourceBundle.getBundle(bundleName, locale, MessageUtils.class.getClassLoader());
        }
        catch (MissingResourceException ignore2) {
            try {
                return ResourceBundle.getBundle(bundleName, locale, Thread.currentThread().getContextClassLoader());
            }
            catch (MissingResourceException damned) {
                facesContext.getExternalContext().log("resource bundle " + bundleName + " could not be found");
                return null;
            }
        }
    }

    public static String getLabel(FacesContext facesContext, UIComponent component) {
        if (component == null) {
            return null;
        }
        Object label = component.getAttributes().get("label");
        if (label != null) {
            return label.toString();
        }
        ValueExpression expression = component.getValueExpression("label");
        if (expression != null) {
            return expression.getExpressionString();
        }
        return component.getClientId(facesContext);
    }
}

