/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.util.NumberFactory;

abstract class AbstractPcg6432
extends IntProvider {
    private static final int SEED_SIZE = 2;
    private static final long DEFAULT_INCREMENT = 1442695040888963407L;
    private long state;
    private long increment;

    AbstractPcg6432(Long seed) {
        this.increment = 1442695040888963407L;
        this.state = this.bump(seed + this.increment);
    }

    AbstractPcg6432(long[] seed) {
        if (seed.length < 2) {
            long[] tmp = new long[2];
            this.fillState(tmp, seed);
            this.setSeedInternal(tmp);
        } else {
            this.setSeedInternal(seed);
        }
    }

    private void setSeedInternal(long[] seed) {
        this.increment = seed[1] << 1 | 1L;
        this.state = this.bump(seed[0] + this.increment);
    }

    private long bump(long input) {
        return input * 6364136223846793005L + this.increment;
    }

    @Override
    public int next() {
        long x = this.state;
        this.state = this.bump(this.state);
        return this.transform(x);
    }

    protected abstract int transform(long var1);

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.state, this.increment >>> 1}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 16);
        long[] tempseed = NumberFactory.makeLongArray(c[0]);
        this.state = tempseed[0];
        this.increment = tempseed[1] << 1 | 1L;
        super.setStateInternal(c[1]);
    }
}

