/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousInverseCumulativeProbabilityFunction;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;

public class InverseTransformContinuousSampler
extends SamplerBase
implements SharedStateContinuousSampler {
    private final ContinuousInverseCumulativeProbabilityFunction function;
    private final UniformRandomProvider rng;

    public InverseTransformContinuousSampler(UniformRandomProvider rng, ContinuousInverseCumulativeProbabilityFunction function) {
        super(null);
        this.rng = rng;
        this.function = function;
    }

    @Override
    public double sample() {
        return this.function.inverseCumulativeProbability(this.rng.nextDouble());
    }

    @Override
    public String toString() {
        return this.function.toString() + " (inverse method) [" + this.rng.toString() + "]";
    }

    @Override
    public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new InverseTransformContinuousSampler(rng, this.function);
    }

    public static SharedStateContinuousSampler of(UniformRandomProvider rng, ContinuousInverseCumulativeProbabilityFunction function) {
        return new InverseTransformContinuousSampler(rng, function);
    }
}

