/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import java.util.stream.Stream;
import org.apache.commons.rng.SplittableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source64.AbstractL64X128;
import org.apache.commons.rng.core.source64.LXMSupport;
import org.apache.commons.rng.core.util.RandomStreams;

public class L64X128StarStar
extends AbstractL64X128
implements SplittableUniformRandomProvider {
    public L64X128StarStar(long[] seed) {
        super(seed);
    }

    public L64X128StarStar(long seed0, long seed1, long seed2, long seed3) {
        super(seed0, seed1, seed2, seed3);
    }

    protected L64X128StarStar(L64X128StarStar source) {
        super(source);
    }

    @Override
    public long next() {
        long s0 = this.x0;
        long s = this.ls;
        long z = Long.rotateLeft((s + s0) * 5L, 7) * 9L;
        this.ls = -3372029247567499371L * s + this.la;
        long s1 = this.x1;
        this.x0 = Long.rotateLeft(s0, 24) ^ (s1 ^= s0) ^ s1 << 16;
        this.x1 = Long.rotateLeft(s1, 37);
        return z;
    }

    @Override
    protected L64X128StarStar copy() {
        return new L64X128StarStar(this);
    }

    public SplittableUniformRandomProvider split(UniformRandomProvider source) {
        return L64X128StarStar.create(source.nextLong(), source);
    }

    public Stream<SplittableUniformRandomProvider> splits(long streamSize, SplittableUniformRandomProvider source) {
        return RandomStreams.generateWithSeed(streamSize, source, L64X128StarStar::create);
    }

    private static SplittableUniformRandomProvider create(long seed, UniformRandomProvider source) {
        long x1;
        long s0 = seed << 1;
        long s1 = source.nextLong();
        long x0 = source.nextLong();
        if ((x0 | (x1 = source.nextLong())) == 0L) {
            x0 = LXMSupport.lea64(s1);
            x1 = LXMSupport.lea64(s1 + -7046029254386353131L);
        }
        return new L64X128StarStar(s0, s1, x0, x1);
    }
}

