/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.JumpableUniformRandomProvider;
import org.apache.commons.rng.LongJumpableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source64.LXMSupport;
import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

abstract class AbstractL128
extends LongProvider
implements LongJumpableUniformRandomProvider {
    private static final int SEED_SIZE = 4;
    private static final long ML = -3024805186288043011L;
    protected long lah;
    protected long lal;
    protected long lsh;
    protected long lsl;

    AbstractL128(long[] seed) {
        this.setState(AbstractL128.extendSeed(seed, 4));
    }

    AbstractL128(long seed0, long seed1, long seed2, long seed3) {
        this.lah = seed0;
        this.lal = seed1 | 1L;
        this.lsh = seed2;
        this.lsl = seed3;
    }

    AbstractL128(AbstractL128 source) {
        super(source);
        this.lah = source.lah;
        this.lal = source.lal;
        this.lsh = source.lsh;
        this.lsl = source.lsl;
    }

    private void setState(long[] state) {
        this.lah = state[0];
        this.lal = state[1] | 1L;
        this.lsh = state[2];
        this.lsl = state[3];
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.lah, this.lal, this.lsh, this.lsl}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 32);
        this.setState(NumberFactory.makeLongArray(c[0]));
        super.setStateInternal(c[1]);
    }

    public UniformRandomProvider jump() {
        AbstractL128 copy = this.copy();
        long sh = this.lsh;
        long sl = this.lsl;
        long u = -3024805186288043011L * sl;
        this.lsh = -3024805186288043011L * sh + LXMSupport.unsignedMultiplyHigh(-3024805186288043011L, sl) + sl + this.lah + LXMSupport.unsignedAddHigh(u, this.lal);
        this.lsl = u + this.lal;
        this.resetCachedState();
        return copy;
    }

    public JumpableUniformRandomProvider longJump() {
        AbstractL128 copy = this.copy();
        this.lsh = this.lsh + 3598791670994785524L * this.lsl + 6995105244622518211L * this.lal;
        this.resetCachedState();
        return copy;
    }

    abstract AbstractL128 copy();
}

