/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;

public class ZigguratNormalizedGaussianSampler
implements NormalizedGaussianSampler,
SharedStateContinuousSampler {
    private static final double R = 3.654152885361009;
    private static final double ONE_OVER_R = 0.2736612373297583;
    private static final int LAST = 255;
    private static final long[] K;
    private static final double[] W;
    private static final double[] F;
    private final UniformRandomProvider rng;

    public ZigguratNormalizedGaussianSampler(UniformRandomProvider rng) {
        this.rng = rng;
    }

    @Override
    public double sample() {
        long j = this.rng.nextLong();
        int i = (int)j & 0xFF;
        if (Math.abs(j) < K[i]) {
            return (double)j * W[i];
        }
        return this.fix(j, i);
    }

    public String toString() {
        return "Ziggurat normalized Gaussian deviate [" + this.rng.toString() + "]";
    }

    private double fix(long hz, int iz) {
        if (iz == 0) {
            double x;
            double y;
            while ((y = -Math.log(InternalUtils.makeNonZeroDouble(this.rng.nextLong()))) + y < (x = -Math.log(InternalUtils.makeNonZeroDouble(this.rng.nextLong())) * 0.2736612373297583) * x) {
            }
            double out = 3.654152885361009 + x;
            return hz > 0L ? out : -out;
        }
        double x = (double)hz * W[iz];
        if (F[iz] + this.rng.nextDouble() * (F[iz - 1] - F[iz]) < ZigguratNormalizedGaussianSampler.pdf(x)) {
            return x;
        }
        return this.sample();
    }

    private static double pdf(double x) {
        return Math.exp(-0.5 * x * x);
    }

    @Override
    public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new ZigguratNormalizedGaussianSampler(rng);
    }

    public static <S extends NormalizedGaussianSampler & SharedStateContinuousSampler> S of(UniformRandomProvider rng) {
        return (S)new ZigguratNormalizedGaussianSampler(rng);
    }

    static {
        double d;
        double v = 0.00492867323399;
        double max = Math.pow(2.0, 63.0);
        double oneOverMax = 1.0 / max;
        K = new long[256];
        W = new double[256];
        F = new double[256];
        double t = d = 3.654152885361009;
        double fd = ZigguratNormalizedGaussianSampler.pdf(d);
        double q = 0.00492867323399 / fd;
        ZigguratNormalizedGaussianSampler.K[0] = (long)(d / q * max);
        ZigguratNormalizedGaussianSampler.K[1] = 0L;
        ZigguratNormalizedGaussianSampler.W[0] = q * oneOverMax;
        ZigguratNormalizedGaussianSampler.W[255] = d * oneOverMax;
        ZigguratNormalizedGaussianSampler.F[0] = 1.0;
        ZigguratNormalizedGaussianSampler.F[255] = fd;
        for (int i = 254; i >= 1; --i) {
            d = Math.sqrt(-2.0 * Math.log(0.00492867323399 / d + fd));
            fd = ZigguratNormalizedGaussianSampler.pdf(d);
            ZigguratNormalizedGaussianSampler.K[i + 1] = (long)(d / t * max);
            t = d;
            ZigguratNormalizedGaussianSampler.F[i] = fd;
            ZigguratNormalizedGaussianSampler.W[i] = d * oneOverMax;
        }
    }
}

