/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.SharedStateObjectSampler;
import org.apache.commons.rng.sampling.distribution.AhrensDieterMarsagliaTsangGammaSampler;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratSampler;

public abstract class DirichletSampler
implements SharedStateObjectSampler<double[]> {
    private static final int MIN_CATGEORIES = 2;
    private final UniformRandomProvider rng;

    DirichletSampler(UniformRandomProvider rng) {
        this.rng = rng;
    }

    public String toString() {
        return "Dirichlet deviate [" + this.rng.toString() + "]";
    }

    @Override
    public double[] sample() {
        int i;
        double[] y = new double[this.getK()];
        double norm = 0.0;
        for (i = 0; i < y.length; ++i) {
            double yi = this.nextGamma(i);
            norm += yi;
            y[i] = yi;
        }
        if (!DirichletSampler.isNonZeroPositiveFinite(norm = 1.0 / norm)) {
            return this.sample();
        }
        i = 0;
        while (i < y.length) {
            int n = i++;
            y[n] = y[n] * norm;
        }
        return y;
    }

    protected abstract int getK();

    protected abstract double nextGamma(int var1);

    @Override
    public abstract DirichletSampler withUniformRandomProvider(UniformRandomProvider var1);

    public static DirichletSampler of(UniformRandomProvider rng, double ... alpha) {
        DirichletSampler.validateNumberOfCategories(alpha.length);
        SharedStateContinuousSampler[] samplers = new SharedStateContinuousSampler[alpha.length];
        for (int i = 0; i < samplers.length; ++i) {
            samplers[i] = DirichletSampler.createSampler(rng, alpha[i]);
        }
        return new GeneralDirichletSampler(rng, samplers);
    }

    public static DirichletSampler symmetric(UniformRandomProvider rng, int k, double alpha) {
        DirichletSampler.validateNumberOfCategories(k);
        SharedStateContinuousSampler sampler = DirichletSampler.createSampler(rng, alpha);
        return new SymmetricDirichletSampler(rng, k, sampler);
    }

    private static void validateNumberOfCategories(int k) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid number of categories: " + k);
        }
    }

    private static SharedStateContinuousSampler createSampler(UniformRandomProvider rng, double alpha) {
        InternalUtils.requireStrictlyPositiveFinite(alpha, "alpha concentration");
        if (alpha == 1.0) {
            return ZigguratSampler.Exponential.of(rng);
        }
        return AhrensDieterMarsagliaTsangGammaSampler.of(rng, alpha, 1.0);
    }

    private static boolean isNonZeroPositiveFinite(double x) {
        return x > 0.0 && x < Double.POSITIVE_INFINITY;
    }

    private static final class SymmetricDirichletSampler
    extends DirichletSampler {
        private final int k;
        private final SharedStateContinuousSampler sampler;

        SymmetricDirichletSampler(UniformRandomProvider rng, int k, SharedStateContinuousSampler sampler) {
            super(rng);
            this.k = k;
            this.sampler = sampler;
        }

        @Override
        protected int getK() {
            return this.k;
        }

        @Override
        protected double nextGamma(int i) {
            return this.sampler.sample();
        }

        @Override
        public SymmetricDirichletSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new SymmetricDirichletSampler(rng, this.k, (SharedStateContinuousSampler)this.sampler.withUniformRandomProvider(rng));
        }
    }

    private static final class GeneralDirichletSampler
    extends DirichletSampler {
        private final SharedStateContinuousSampler[] samplers;

        GeneralDirichletSampler(UniformRandomProvider rng, SharedStateContinuousSampler[] samplers) {
            super(rng);
            this.samplers = samplers;
        }

        @Override
        protected int getK() {
            return this.samplers.length;
        }

        @Override
        protected double nextGamma(int i) {
            return this.samplers[i].sample();
        }

        @Override
        public GeneralDirichletSampler withUniformRandomProvider(UniformRandomProvider rng) {
            SharedStateContinuousSampler[] newSamplers = new SharedStateContinuousSampler[this.samplers.length];
            for (int i = 0; i < newSamplers.length; ++i) {
                newSamplers[i] = (SharedStateContinuousSampler)this.samplers[i].withUniformRandomProvider(rng);
            }
            return new GeneralDirichletSampler(rng, newSamplers);
        }
    }
}

