/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.SharedStateObjectSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratSampler;

public class UnitSphereSampler
implements SharedStateObjectSampler<double[]> {
    private static final int ONE_D = 1;
    private static final int TWO_D = 2;
    private static final int THREE_D = 3;
    private static final int MASK_BIT_2 = 2;
    private final UnitSphereSampler delegate;

    @Deprecated
    public UnitSphereSampler(int dimension, UniformRandomProvider rng) {
        this(UnitSphereSampler.of(rng, dimension));
    }

    private UnitSphereSampler(UnitSphereSampler delegate) {
        this.delegate = delegate;
    }

    private UnitSphereSampler() {
        this.delegate = null;
    }

    @Override
    public double[] sample() {
        return this.delegate.sample();
    }

    @Deprecated
    public double[] nextVector() {
        return this.sample();
    }

    @Override
    public UnitSphereSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return this.delegate.withUniformRandomProvider(rng);
    }

    public static UnitSphereSampler of(UniformRandomProvider rng, int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException("Dimension must be strictly positive");
        }
        if (dimension == 1) {
            return new UnitSphereSampler1D(rng);
        }
        if (dimension == 2) {
            return new UnitSphereSampler2D(rng);
        }
        if (dimension == 3) {
            return new UnitSphereSampler3D(rng);
        }
        return new UnitSphereSamplerND(rng, dimension);
    }

    private static final class UnitSphereSamplerND
    extends UnitSphereSampler {
        private final int dimension;
        private final NormalizedGaussianSampler sampler;

        UnitSphereSamplerND(UniformRandomProvider rng, int dimension) {
            this.dimension = dimension;
            this.sampler = ZigguratSampler.NormalizedGaussian.of(rng);
        }

        @Override
        public double[] sample() {
            double[] v = new double[this.dimension];
            double sum = 0.0;
            for (int i = 0; i < this.dimension; ++i) {
                double x;
                v[i] = x = this.sampler.sample();
                sum += x * x;
            }
            if (sum == 0.0) {
                return this.sample();
            }
            double f = 1.0 / Math.sqrt(sum);
            int i = 0;
            while (i < this.dimension) {
                int n = i++;
                v[n] = v[n] * f;
            }
            return v;
        }

        @Override
        public UnitSphereSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new UnitSphereSamplerND(rng, this.dimension);
        }
    }

    private static final class UnitSphereSampler3D
    extends UnitSphereSampler {
        private final NormalizedGaussianSampler sampler;

        UnitSphereSampler3D(UniformRandomProvider rng) {
            this.sampler = ZigguratSampler.NormalizedGaussian.of(rng);
        }

        @Override
        public double[] sample() {
            double z;
            double y;
            double x = this.sampler.sample();
            double sum = x * x + (y = this.sampler.sample()) * y + (z = this.sampler.sample()) * z;
            if (sum == 0.0) {
                return this.sample();
            }
            double f = 1.0 / Math.sqrt(sum);
            return new double[]{x * f, y * f, z * f};
        }

        @Override
        public UnitSphereSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new UnitSphereSampler3D(rng);
        }
    }

    private static final class UnitSphereSampler2D
    extends UnitSphereSampler {
        private final NormalizedGaussianSampler sampler;

        UnitSphereSampler2D(UniformRandomProvider rng) {
            this.sampler = ZigguratSampler.NormalizedGaussian.of(rng);
        }

        @Override
        public double[] sample() {
            double y;
            double x = this.sampler.sample();
            double sum = x * x + (y = this.sampler.sample()) * y;
            if (sum == 0.0) {
                return this.sample();
            }
            double f = 1.0 / Math.sqrt(sum);
            return new double[]{x * f, y * f};
        }

        @Override
        public UnitSphereSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new UnitSphereSampler2D(rng);
        }
    }

    private static final class UnitSphereSampler1D
    extends UnitSphereSampler {
        private final UniformRandomProvider rng;

        UnitSphereSampler1D(UniformRandomProvider rng) {
            this.rng = rng;
        }

        @Override
        public double[] sample() {
            return new double[]{1.0 - (double)(this.rng.nextInt() >>> 30 & 2)};
        }

        @Override
        public UnitSphereSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new UnitSphereSampler1D(rng);
        }
    }
}

