/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import org.apache.commons.rng.UniformRandomProvider;

final class SubsetSamplerUtils {
    private SubsetSamplerUtils() {
    }

    static void checkSubset(int n, int k) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0 : n=" + n);
        }
        if (k <= 0) {
            throw new IllegalArgumentException("k <= 0 : k=" + k);
        }
        if (k > n) {
            throw new IllegalArgumentException("k > n : k=" + k + ", n=" + n);
        }
    }

    static int[] partialSample(int[] domain, int steps, UniformRandomProvider rng, boolean upper) {
        int i = domain.length - 1;
        for (int swapCount = Math.min(steps, domain.length - 1); swapCount > 0; --swapCount) {
            SubsetSamplerUtils.swap(domain, i, rng.nextInt(i + 1));
            --i;
        }
        int size = upper ? steps : domain.length - steps;
        int from = upper ? domain.length - steps : 0;
        int[] result = new int[size];
        System.arraycopy(domain, from, result, 0, size);
        return result;
    }

    static void swap(int[] array, int i, int j) {
        int tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }
}

