/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.PermutationSampler;

public final class ListSampler {
    private static final int RANDOM_ACCESS_SIZE_THRESHOLD = 4;

    private ListSampler() {
    }

    public static <T> List<T> sample(UniformRandomProvider rng, List<T> collection, int k) {
        int n = collection.size();
        PermutationSampler p = new PermutationSampler(rng, n, k);
        ArrayList<T> result = new ArrayList<T>(k);
        int[] index = p.sample();
        for (int i = 0; i < k; ++i) {
            result.add(collection.get(index[i]));
        }
        return result;
    }

    public static <T> void shuffle(UniformRandomProvider rng, List<T> list) {
        if (list instanceof RandomAccess || list.size() < 4) {
            for (int i = list.size(); i > 1; --i) {
                ListSampler.swap(list, i - 1, rng.nextInt(i));
            }
        } else {
            Object[] array = list.toArray();
            for (int i = array.length; i > 1; --i) {
                ListSampler.swap(array, i - 1, rng.nextInt(i));
            }
            ListIterator<T> it = list.listIterator();
            for (Object item : array) {
                it.next();
                it.set(item);
            }
        }
    }

    public static <T> void shuffle(UniformRandomProvider rng, List<T> list, int start, boolean towardHead) {
        if (towardHead) {
            ListSampler.shuffle(rng, list.subList(0, start + 1));
        } else {
            ListSampler.shuffle(rng, list.subList(start, list.size()));
        }
    }

    private static <T> void swap(List<T> list, int i, int j) {
        T tmp = list.get(i);
        list.set(i, list.get(j));
        list.set(j, tmp);
    }

    private static void swap(Object[] array, int i, int j) {
        Object tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }
}

