/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng;

import java.util.Objects;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.UniformRandomProviderSupport;

public interface SplittableUniformRandomProvider
extends UniformRandomProvider {
    default public SplittableUniformRandomProvider split() {
        return this.split(this);
    }

    public SplittableUniformRandomProvider split(UniformRandomProvider var1);

    default public Stream<SplittableUniformRandomProvider> splits() {
        return this.splits(Long.MAX_VALUE, this);
    }

    default public Stream<SplittableUniformRandomProvider> splits(SplittableUniformRandomProvider source) {
        return this.splits(Long.MAX_VALUE, source);
    }

    default public Stream<SplittableUniformRandomProvider> splits(long streamSize) {
        return this.splits(streamSize, this);
    }

    default public Stream<SplittableUniformRandomProvider> splits(long streamSize, SplittableUniformRandomProvider source) {
        UniformRandomProviderSupport.validateStreamSize(streamSize);
        Objects.requireNonNull(source, "source");
        return StreamSupport.stream(new UniformRandomProviderSupport.ProviderSplitsSpliterator(0L, streamSize, source, this), false);
    }

    @Override
    default public IntStream ints() {
        return this.ints(Long.MAX_VALUE);
    }

    @Override
    default public IntStream ints(int origin, int bound) {
        return this.ints(Long.MAX_VALUE, origin, bound);
    }

    @Override
    default public IntStream ints(long streamSize) {
        UniformRandomProviderSupport.validateStreamSize(streamSize);
        return StreamSupport.intStream(new UniformRandomProviderSupport.ProviderIntsSpliterator(0L, streamSize, this, UniformRandomProvider::nextInt), false);
    }

    @Override
    default public IntStream ints(long streamSize, int origin, int bound) {
        UniformRandomProviderSupport.validateStreamSize(streamSize);
        UniformRandomProviderSupport.validateRange(origin, bound);
        return StreamSupport.intStream(new UniformRandomProviderSupport.ProviderIntsSpliterator(0L, streamSize, this, rng -> rng.nextInt(origin, bound)), false);
    }

    @Override
    default public LongStream longs() {
        return this.longs(Long.MAX_VALUE);
    }

    @Override
    default public LongStream longs(long origin, long bound) {
        return this.longs(Long.MAX_VALUE, origin, bound);
    }

    @Override
    default public LongStream longs(long streamSize) {
        UniformRandomProviderSupport.validateStreamSize(streamSize);
        return StreamSupport.longStream(new UniformRandomProviderSupport.ProviderLongsSpliterator(0L, streamSize, this, UniformRandomProvider::nextLong), false);
    }

    @Override
    default public LongStream longs(long streamSize, long origin, long bound) {
        UniformRandomProviderSupport.validateStreamSize(streamSize);
        UniformRandomProviderSupport.validateRange(origin, bound);
        return StreamSupport.longStream(new UniformRandomProviderSupport.ProviderLongsSpliterator(0L, streamSize, this, rng -> rng.nextLong(origin, bound)), false);
    }

    @Override
    default public DoubleStream doubles() {
        return this.doubles(Long.MAX_VALUE);
    }

    @Override
    default public DoubleStream doubles(double origin, double bound) {
        return this.doubles(Long.MAX_VALUE, origin, bound);
    }

    @Override
    default public DoubleStream doubles(long streamSize) {
        UniformRandomProviderSupport.validateStreamSize(streamSize);
        return StreamSupport.doubleStream(new UniformRandomProviderSupport.ProviderDoublesSpliterator(0L, streamSize, this, UniformRandomProvider::nextDouble), false);
    }

    @Override
    default public DoubleStream doubles(long streamSize, double origin, double bound) {
        UniformRandomProviderSupport.validateStreamSize(streamSize);
        UniformRandomProviderSupport.validateRange(origin, bound);
        return StreamSupport.doubleStream(new UniformRandomProviderSupport.ProviderDoublesSpliterator(0L, streamSize, this, rng -> rng.nextDouble(origin, bound)), false);
    }
}

