/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.dbcp2.PStmtKey;
import org.apache.commons.dbcp2.PoolablePreparedStatement;
import org.apache.commons.dbcp2.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUtils {
    public static PStmtKey getPStmtKey(PoolablePreparedStatement<PStmtKey> poolablePreparedStatement) {
        return (PStmtKey)poolablePreparedStatement.getKey();
    }

    @Test
    public void testCheckForConflictsBothCollectionsNull() {
        Assertions.assertDoesNotThrow(() -> Utils.checkSqlCodes(null, null));
    }

    @Test
    public void testCheckForConflictsEmptyCollections() {
        Set codes1 = Collections.emptySet();
        Set codes2 = Collections.emptySet();
        Assertions.assertDoesNotThrow(() -> Utils.checkSqlCodes((Collection)codes1, (Collection)codes2));
    }

    @Test
    public void testCheckForConflictsFirstCollectionNull() {
        Collection codes1 = null;
        HashSet<String> codes2 = new HashSet<String>(Arrays.asList("08005", "08007"));
        Assertions.assertDoesNotThrow(() -> Utils.checkSqlCodes((Collection)codes1, (Collection)codes2));
    }

    @Test
    public void testCheckForConflictsNoOverlap() {
        HashSet<String> codes1 = new HashSet<String>(Arrays.asList("08003", "08006"));
        HashSet<String> codes2 = new HashSet<String>(Arrays.asList("08005", "08007"));
        Assertions.assertDoesNotThrow(() -> Utils.checkSqlCodes((Collection)codes1, (Collection)codes2));
    }

    @Test
    public void testCheckForConflictsSecondCollectionNull() {
        HashSet<String> codes1 = new HashSet<String>(Arrays.asList("08003", "08006"));
        Collection codes2 = null;
        Assertions.assertDoesNotThrow(() -> Utils.checkSqlCodes((Collection)codes1, (Collection)codes2));
    }

    @Test
    public void testCheckForConflictsWith1Overlap() {
        HashSet<String> codes1 = new HashSet<String>(Arrays.asList("08003", "08006"));
        HashSet<String> codes2 = new HashSet<String>(Arrays.asList("08005", "08006"));
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Utils.checkSqlCodes((Collection)codes1, (Collection)codes2));
        Assertions.assertEquals((Object)"[08006] cannot be in both disconnectionSqlCodes and disconnectionIgnoreSqlCodes.", (Object)exception.getMessage());
    }

    @Test
    public void testCheckForConflictsWith2Overlap() {
        HashSet<String> codes1 = new HashSet<String>(Arrays.asList("08003", "08006", "08007"));
        HashSet<String> codes2 = new HashSet<String>(Arrays.asList("08005", "08006", "08007"));
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Utils.checkSqlCodes((Collection)codes1, (Collection)codes2));
        Assertions.assertEquals((Object)"[08006, 08007] cannot be in both disconnectionSqlCodes and disconnectionIgnoreSqlCodes.", (Object)exception.getMessage());
    }

    @Test
    public void testClassLoads() {
        Utils.closeQuietly((AutoCloseable)null);
    }

    @Test
    public void testIsDisconnectionSqlCode() {
        Assertions.assertTrue((boolean)Utils.isDisconnectionSqlCode((String)"57P01"), (String)"57P01 should be recognised as a disconnection SQL code.");
        Assertions.assertTrue((boolean)Utils.isDisconnectionSqlCode((String)"01002"), (String)"01002 should be recognised as a disconnection SQL code.");
        Assertions.assertTrue((boolean)Utils.isDisconnectionSqlCode((String)"JZ0C0"), (String)"JZ0C0 should be recognised as a disconnection SQL code.");
        Assertions.assertFalse((boolean)Utils.isDisconnectionSqlCode((String)"INVALID"), (String)"INVALID should not be recognised as a disconnection SQL code.");
        Assertions.assertFalse((boolean)Utils.isDisconnectionSqlCode((String)"00000"), (String)"00000 should not be recognised as a disconnection SQL code.");
    }
}

