/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.object;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenType;
import org.jolokia.json.JSONObject;
import org.jolokia.json.JSONStructure;
import org.jolokia.json.parser.JSONParser;
import org.jolokia.json.parser.ParseException;
import org.jolokia.service.serializer.object.Converter;
import org.jolokia.service.serializer.object.ObjectToOpenTypeConverter;

abstract class OpenTypeConverter<T extends OpenType<?>>
implements Converter<T> {
    protected boolean forgiving = false;
    protected final ObjectToOpenTypeConverter objectToOpenTypeConverter;

    OpenTypeConverter(ObjectToOpenTypeConverter objectToOpenTypeConverter) {
        this.objectToOpenTypeConverter = objectToOpenTypeConverter;
    }

    abstract boolean canConvert(OpenType<?> var1);

    protected static String getMXBeanTypeName(OpenType<?> type) {
        if (type.isArray()) {
            return OpenTypeConverter.getMXBeanTypeName(((ArrayType)type).getElementOpenType());
        }
        return type.getTypeName();
    }

    protected <J extends JSONStructure> J toJSON(Object pValue, Class<J> jsonType) {
        Class<?> givenClass = pValue.getClass();
        if (givenClass == jsonType) {
            return (J)((JSONStructure)jsonType.cast(pValue));
        }
        if (pValue instanceof String) {
            try {
                return (J)((JSONStructure)new JSONParser().parse((String)pValue, jsonType));
            }
            catch (IOException | ParseException e) {
                throw new IllegalArgumentException("Cannot parse JSON " + this.trim((String)pValue) + ": " + e.getMessage(), e);
            }
        }
        throw new IllegalArgumentException("Given value " + String.valueOf(pValue) + " cannot be parsed to a " + jsonType.getName() + " object");
    }

    protected void ensureStringKeys(Map<?, ?> pValue, Set<Integer> identities) {
        boolean added = identities.add(System.identityHashCode(pValue));
        if (!added) {
            return;
        }
        for (Map.Entry<?, ?> e : pValue.entrySet()) {
            if (!(e.getKey() instanceof String)) {
                throw new IllegalArgumentException("Can't process Map with non-String keys");
            }
            if (!(e.getValue() instanceof Map)) continue;
            this.ensureStringKeys((Map)e.getValue(), identities);
        }
    }

    protected Map<String, Object> toMap(Object pValue) {
        if (pValue instanceof JSONObject) {
            return (JSONObject)pValue;
        }
        if (pValue instanceof Map) {
            this.ensureStringKeys((Map)pValue, new HashSet<Integer>());
            return (Map)pValue;
        }
        return (Map)this.toJSON(pValue, JSONObject.class);
    }

    protected boolean isForgiving() {
        return this.forgiving || this.objectToOpenTypeConverter != null && this.objectToOpenTypeConverter.isForgiving();
    }

    protected String trim(String pValue) {
        return pValue.length() > 64 ? pValue.substring(0, 64) + "..." : pValue;
    }
}

