# Generated by default/object.tt
package Paws::MediaTailor::AccessConfiguration;
  use Moose;
  has AccessType => (is => 'ro', isa => 'Str');
  has SecretsManagerAccessTokenConfiguration => (is => 'ro', isa => 'Paws::MediaTailor::SecretsManagerAccessTokenConfiguration');

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaTailor::AccessConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaTailor::AccessConfiguration object:

  $service_obj->Method(Att1 => { AccessType => $value, ..., SecretsManagerAccessTokenConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaTailor::AccessConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessType

=head1 DESCRIPTION

Access configuration parameters.

=head1 ATTRIBUTES


=head2 AccessType => Str

The type of authentication used to access content from
HttpConfiguration::BaseUrl on your source location. Accepted value:
S3_SIGV4.

S3_SIGV4 - AWS Signature Version 4 authentication for Amazon S3 hosted
virtual-style access. If your source location base URL is an Amazon S3
bucket, MediaTailor can use AWS Signature Version 4 (SigV4)
authentication to access the bucket where your source content is
stored. Your MediaTailor source location baseURL must follow the S3
virtual hosted-style request URL format. For example,
https://bucket-name.s3.Region.amazonaws.com/key-name.

Before you can use S3_SIGV4, you must meet these requirements:

E<bull> You must allow MediaTailor to access your S3 bucket by granting
mediatailor.amazonaws.com principal access in IAM. For information
about configuring access in IAM, see Access management in the IAM User
Guide.

E<bull> The mediatailor.amazonaws.com service principal must have
permissions to read all top level manifests referenced by the VodSource
packaging configurations.

E<bull> The caller of the API must have s3:GetObject IAM permissions to
read all top level manifests referenced by your MediaTailor VodSource
packaging configurations.


=head2 SecretsManagerAccessTokenConfiguration => L<Paws::MediaTailor::SecretsManagerAccessTokenConfiguration>

AWS Secrets Manager access token configuration parameters.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaTailor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

