# Generated by default/object.tt
package Paws::Lambda::FileSystemConfig;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', required => 1);
  has LocalMountPath => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lambda::FileSystemConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lambda::FileSystemConfig object:

  $service_obj->Method(Att1 => { Arn => $value, ..., LocalMountPath => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lambda::FileSystemConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Details about the connection between a Lambda function and an Amazon
EFS file system
(https://docs.aws.amazon.com/lambda/latest/dg/configuration-filesystem.html).

=head1 ATTRIBUTES


=head2 B<REQUIRED> Arn => Str

The Amazon Resource Name (ARN) of the Amazon EFS access point that
provides access to the file system.


=head2 B<REQUIRED> LocalMountPath => Str

The path where the function can access the file system, starting with
C</mnt/>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lambda>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

