#!perl -T

use Test::More tests => 2;

use Mail::SNCF::ICal;
use Data::ICal;

my @lines = <DATA>;
my $output = join("", @lines);
my $ical = Data::ICal->new(data => $output);

my $file = "t/sncf";
my $sncf = Mail::SNCF::ICal->parse($file);

TODO: {
local $TODO = "Do not understand dates in ical files";
is_deeply($$sncf, $ical, "Ical produce a good ical object");
is($sncf->as_string, $output, "Ical output works");
}

__DATA__
BEGIN:VCALENDAR
PRODID:Data::ICal 0.13
VERSION:2.0
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090105T084900Z
DTSTART:20090105T064700Z
SUMMARY:MASSY TGV -> RENNES
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090109T154700Z
DTSTART:20090109T133500Z
SUMMARY:RENNES -> MASSY TGV
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090112T110800Z
DTSTART:20090112T090500Z
SUMMARY:PARIS MONTPARNASSE 1 ET 2 -> RENNES
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090112T194800Z
DTSTART:20090112T173900Z
SUMMARY:RENNES -> MASSY TGV
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090114T110800Z
DTSTART:20090114T090500Z
SUMMARY:PARIS MONTPARNASSE 1 ET 2 -> RENNES
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090115T194800Z
DTSTART:20090115T173900Z
SUMMARY:RENNES -> MASSY TGV
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090123T084900Z
DTSTART:20090123T064700Z
SUMMARY:MASSY TGV -> RENNES
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090123T201800Z
DTSTART:20090123T180900Z
SUMMARY:RENNES -> MASSY TGV
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090202T084900Z
DTSTART:20090202T064700Z
SUMMARY:MASSY TGV -> RENNES
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090211T182200Z
DTSTART:20090211T151600Z
SUMMARY:PARIS GARE DE LYON -> MARSEILLE ST CHARLES
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090213T165000Z
DTSTART:20090213T132200Z
SUMMARY:ST RAPHAEL VALESCURE -> LYON PART DIEU
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090206T182200Z
DTSTART:20090206T161000Z
SUMMARY:RENNES -> MASSY TGV
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090209T110800Z
DTSTART:20090209T090500Z
SUMMARY:PARIS MONTPARNASSE 1 ET 2 -> RENNES
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090213T173100Z
DTSTART:20090213T131400Z
SUMMARY:RENNES -> LYON PART DIEU
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090216T183500Z
DTSTART:20090216T162600Z
SUMMARY:LYON PART DIEU -> MASSY PALAISEAU
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090217T084900Z
DTSTART:20090217T064700Z
SUMMARY:MASSY TGV -> RENNES
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090220T182200Z
DTSTART:20090220T161000Z
SUMMARY:RENNES -> MASSY TGV
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090223T110800Z
DTSTART:20090223T090500Z
SUMMARY:PARIS MONTPARNASSE 1 ET 2 -> RENNES
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090227T182200Z
DTSTART:20090227T161000Z
SUMMARY:RENNES -> MASSY TGV
END:VEVENT
BEGIN:VEVENT
DESCRIPTION:
DTEND:20090302T110800Z
DTSTART:20090302T090500Z
SUMMARY:PARIS MONTPARNASSE 1 ET 2 -> RENNES
END:VEVENT
END:VCALENDAR
