package Lido::XML::LIDO_1_0::geometryBasic2d;

use Moo;

our $VERSION = '0.02';

sub content {
	my @lines = <DATA>;
	join '' , @lines;
}

1;
__DATA__
<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XMLSPY v5 rel. 2 U (http://www.xmlspy.com) by Clemens Portele (interactive instruments) -->
<schema targetNamespace="http://www.opengis.net/gml" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:gml="http://www.opengis.net/gml" xmlns:sch="http://www.ascc.net/xml/schematron" xmlns="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified"
        version="3.1.1.2">
	<annotation>
		<appinfo source="urn:opengis:specification:gml:schema-xsd:geometryBasic2d:3.1.1">geometryBasic2d.xsd</appinfo>
		<documentation>
			GML is an OGC Standard.
			Copyright (c) 2001,2005,2010 Open Geospatial Consortium.
			To obtain additional rights of use, visit http://www.opengeospatial.org/legal/ .
		</documentation>
	</annotation>
	<include schemaLocation="gml.xsd"/>
	<include schemaLocation="geometryBasic0d1d.xsd"/>
	<!-- =========================================================== -->
	<!-- primitive geometry objects (2-dimensional) -->
	<!-- =========================================================== -->
	<element name="_Surface" type="gml:AbstractSurfaceType" abstract="true" substitutionGroup="gml:_GeometricPrimitive">
		<annotation>
			<documentation>The "_Surface" element is the abstract head of the substituition group for all (continuous) surface elements.</documentation>
		</annotation>
	</element>
	<!-- =========================================================== -->
	<complexType name="AbstractSurfaceType">
		<annotation>
			<documentation>An abstraction of a surface to support the different levels of complexity. A surface is always a continuous region of a plane.</documentation>
		</annotation>
		<complexContent>
			<extension base="gml:AbstractGeometricPrimitiveType"/>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="surfaceProperty" type="gml:SurfacePropertyType">
		<annotation>
			<appinfo>
				<sch:pattern name="Check either href or content not both">
					<sch:rule context="gml:surfaceProperty">
						<sch:extends rule="hrefOrContent"/>
					</sch:rule>
				</sch:pattern>
			</appinfo>
			<documentation>This property element either references a surface via the XLink-attributes or contains the surface element. surfaceProperty is the predefined property which can be used by GML Application Schemas whenever a GML Feature has a property with a value that is substitutable for _Surface.</documentation>
		</annotation>
	</element>
	<!-- =========================================================== -->
	<complexType name="SurfacePropertyType">
		<annotation>
			<documentation>A property that has a surface as its value domain can either be an appropriate geometry element encapsulated in an element of this type or an XLink reference to a remote geometry element (where remote includes geometry elements located elsewhere in the same document). Either the reference or the contained element must be given, but neither both nor none.</documentation>
		</annotation>
		<sequence minOccurs="0">
			<element ref="gml:_Surface"/>
		</sequence>
		<attributeGroup ref="gml:AssociationAttributeGroup">
			<annotation>
				<documentation>This attribute group includes the XLink attributes (see xlinks.xsd). XLink is used in GML to reference remote resources (including those elsewhere in the same document). A simple link element can be constructed by including a specific set of XLink attributes. The XML Linking Language (XLink) is currently a Proposed Recommendation of the World Wide Web Consortium. XLink allows elements to be inserted into XML documents so as to create sophisticated links between resources; such links can be used to reference remote properties.
A simple link element can be used to implement pointer functionality, and this functionality has been built into various GML 3 elements by including the gml:AssociationAttributeGroup.</documentation>
			</annotation>
		</attributeGroup>
	</complexType>
	<!-- =========================================================== -->
	<element name="surfaceArrayProperty" type="gml:SurfaceArrayPropertyType"/>
	<!-- =========================================================== -->
	<complexType name="SurfaceArrayPropertyType">
		<annotation>
			<documentation>A container for an array of surfaces. The elements are always contained in the array property, referencing geometry elements or arrays of geometry elements is not supported.</documentation>
		</annotation>
		<sequence>
			<element ref="gml:_Surface" minOccurs="0" maxOccurs="unbounded"/>
		</sequence>
	</complexType>
	<!-- =========================================================== -->
	<element name="Polygon" type="gml:PolygonType" substitutionGroup="gml:_Surface"/>
	<!-- =========================================================== -->
	<complexType name="PolygonType">
		<annotation>
			<documentation>A Polygon is a special surface that is defined by a single surface patch. The boundary of this patch is coplanar and the polygon uses planar interpolation in its interior. It is backwards compatible with the Polygon of GML 2, GM_Polygon of ISO 19107 is implemented by PolygonPatch.</documentation>
		</annotation>
		<complexContent>
			<extension base="gml:AbstractSurfaceType">
				<sequence>
					<element ref="gml:exterior" minOccurs="0"/>
					<element ref="gml:interior" minOccurs="0" maxOccurs="unbounded"/>
				</sequence>
			</extension>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<!-- rings (closed curves for surface boundaries) -->
	<!-- =========================================================== -->
	<element name="_Ring" type="gml:AbstractRingType" abstract="true" substitutionGroup="gml:_Geometry">
		<annotation>
			<documentation>The "_Ring" element is the abstract head of the substituition group for all closed boundaries of a surface patch.</documentation>
		</annotation>
	</element>
	<!-- =========================================================== -->
	<complexType name="AbstractRingType" abstract="true">
		<annotation>
			<documentation>An abstraction of a ring to support surface boundaries of different complexity.</documentation>
		</annotation>
		<complexContent>
			<extension base="gml:AbstractGeometryType"/>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<element name="exterior" type="gml:AbstractRingPropertyType">
		<annotation>
			<documentation>A boundary of a surface consists of a number of rings. In the normal 2D case, one of these rings is distinguished as being the exterior boundary. In a general manifold this is not always possible, in which case all boundaries shall be listed as interior boundaries, and the exterior will be empty.</documentation>
		</annotation>
	</element>
	<element name="interior" type="gml:AbstractRingPropertyType">
		<annotation>
			<documentation>A boundary of a surface consists of a number of rings. The "interior" rings seperate the surface / surface patch from the area enclosed by the rings.</documentation>
		</annotation>
	</element>
	<element name="outerBoundaryIs" type="gml:AbstractRingPropertyType" substitutionGroup="gml:exterior">
		<annotation>
			<documentation>Deprecated with GML 3.0, included only for backwards compatibility with GML 2. Use "exterior" instead.</documentation>
		</annotation>
	</element>
	<element name="innerBoundaryIs" type="gml:AbstractRingPropertyType" substitutionGroup="gml:interior">
		<annotation>
			<documentation>Deprecated with GML 3.0, included only for backwards compatibility with GML 2. Use "interior" instead.</documentation>
		</annotation>
	</element>
	<!-- =========================================================== -->
	<complexType name="AbstractRingPropertyType">
		<annotation>
			<documentation>Encapsulates a ring to represent the surface boundary property of a surface.</documentation>
		</annotation>
		<sequence>
			<element ref="gml:_Ring"/>
		</sequence>
	</complexType>
	<!-- =========================================================== -->
	<element name="LinearRing" type="gml:LinearRingType" substitutionGroup="gml:_Ring"/>
	<!-- =========================================================== -->
	<complexType name="LinearRingType">
		<annotation>
			<documentation>A LinearRing is defined by four or more coordinate tuples, with linear interpolation between them; the first and last coordinates must be coincident.</documentation>
		</annotation>
		<complexContent>
			<extension base="gml:AbstractRingType">
				<sequence>
					<choice>
						<annotation>
							<documentation>GML supports two different ways to specify the control points of a linear ring.
1. A sequence of "pos" (DirectPositionType) or "pointProperty" (PointPropertyType) elements. "pos" elements are control points that are only part of this ring, "pointProperty" elements contain a point that may be referenced from other geometry elements or reference another point defined outside of this ring (reuse of existing points).
2. The "posList" element allows for a compact way to specifiy the coordinates of the control points, if all control points are in the same coordinate reference systems and belong to this ring only. The number of direct positions in the list must be at least four.</documentation>
						</annotation>
						<choice minOccurs="4" maxOccurs="unbounded">
							<element ref="gml:pos"/>
							<element ref="gml:pointProperty"/>
							<element ref="gml:pointRep">
								<annotation>
									<documentation>Deprecated with GML version 3.1.0. Use "pointProperty" instead. Included for backwards compatibility with GML 3.0.0.</documentation>
								</annotation>
							</element>
						</choice>
						<element ref="gml:posList"/>
						<element ref="gml:coordinates">
							<annotation>
								<documentation>Deprecated with GML version 3.1.0. Use "posList" instead.</documentation>
							</annotation>
						</element>
						<element ref="gml:coord" minOccurs="4" maxOccurs="unbounded">
							<annotation>
								<documentation>Deprecated with GML version 3.0 and included for backwards compatibility with GML 2. Use "pos" elements instead.</documentation>
							</annotation>
						</element>
					</choice>
				</sequence>
			</extension>
		</complexContent>
	</complexType>
	<!-- =========================================================== -->
	<complexType name="LinearRingPropertyType">
		<annotation>
			<documentation>Encapsulates a ring to represent properties in features or geometry collections.</documentation>
		</annotation>
		<choice>
			<element ref="gml:LinearRing"/>
		</choice>
	</complexType>
	<!-- =========================================================== -->
	<!-- 
	
	The following types and elements are deprecated and should not be used !
	
	-->
	<!-- =========================================================== -->
	<element name="polygonProperty" type="gml:PolygonPropertyType">
		<annotation>
			<documentation>Deprecated with GML 3.0 and included only for backwards compatibility with GML 2.0. Use "surfaceProperty" instead.
This property element either references a polygon via the XLink-attributes or contains the polygon element.</documentation>
		</annotation>
	</element>
	<!-- =========================================================== -->
	<complexType name="PolygonPropertyType">
		<annotation>
			<documentation>This type is deprecated with GML 3 and shall not be used. It is included for backwards compatibility with GML 2. Use SurfacePropertyType instead.
A property that has a polygon as its value domain can either be an appropriate geometry element encapsulated in an element of this type or an XLink reference to a remote geometry element (where remote includes geometry elements located elsewhere in the same document). Either the reference or the contained element must be given, but neither both nor none.</documentation>
		</annotation>
		<sequence minOccurs="0">
			<element ref="gml:Polygon"/>
		</sequence>
		<attributeGroup ref="gml:AssociationAttributeGroup">
			<annotation>
				<documentation>This attribute group includes the XLink attributes (see xlinks.xsd). XLink is used in GML to reference remote resources (including those elsewhere in the same document). A simple link element can be constructed by including a specific set of XLink attributes. The XML Linking Language (XLink) is currently a Proposed Recommendation of the World Wide Web Consortium. XLink allows elements to be inserted into XML documents so as to create sophisticated links between resources; such links can be used to reference remote properties.
A simple link element can be used to implement pointer functionality, and this functionality has been built into various GML 3 elements by including the gml:AssociationAttributeGroup.</documentation>
			</annotation>
		</attributeGroup>
	</complexType>
	<!-- =========================================================== -->
</schema>
