# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::NZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230112200227;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8[1-579]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            50(?:
              [0367]|
              88
            )|
            [89]0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2,3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            24|
            [346]|
            7[2-57-9]|
            9[2-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              10|
              74
            )|
            [59]|
            80
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1|
            2[028]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              [169]|
              7[0-35-9]
            )|
            7|
            86
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,5})'
                }
              ];

my $validators = {
                'fixed_line' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'geographic' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'mobile' => '
          2[0-27-9]\\d{7,8}|
          21\\d{6}
        ',
                'pager' => '[28]6\\d{6,7}',
                'personal_number' => '70\\d{7}',
                'specialrate' => '(
          (?:
            11\\d{5}|
            50(?:
              0[08]|
              30|
              66|
              77|
              88
            )
          )\\d{3}|
          90\\d{6,8}
        )|(
          8(?:
            1[6-9]|
            22|
            3\\d|
            4[045]|
            5[459]|
            7[0-3579]|
            90
          )\\d{2,7}
        )',
                'toll_free' => '
          508\\d{6,7}|
          80\\d{6,8}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"6499047", "Pukekohe",
"647981", "Hamilton",
"6479022", "Morrinsville",
"6473925", "Putaruru\/Tokoroa",
"6479290", "Hamilton",
"6462138", "Palmerston\ North",
"6436657", "Franz\ Josef",
"6439282", "Christchurch",
"6462810", "Gisborne",
"643949", "Dunedin",
"6474654", "Taumarunui",
"6495560", "Whangarei",
"6469004", "Napier\/Hastings",
"6479712", "Te\ Awamutu",
"6469200", "Gisborne",
"64331", "Rangiora\/Amberley\/Culverden\/Darfield\/Cheviot\/Kaikoura",
"6472822", "Rotorua",
"6439531", "Timaru",
"6469296", "Levin",
"649554", "Hibiscus\ Coast",
"6466018", "Napier",
"6494314", "Warkworth",
"6469010", "Taihape",
"647220", "Tauranga",
"6472816", "Morrinsville",
"6436508", "Rangiora",
"6467556", "New\ Plymouth\/Mokau",
"6498016", "Hibiscus\ Coast",
"6462804", "Palmerston\ North",
"6472127", "Paeroa",
"6432662", "Christchurch",
"6469854", "Waipukurau",
"6432669", "Rangiora",
"644586", "Wellington",
"647925", "Tauranga",
"6442198", "Paraparaumu",
"6475618", "Opotiki",
"644587", "Wellington",
"6439450", "Invercargill",
"6434408", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6492228", "Warkworth",
"6436615", "Ashburton",
"646847", "Napier\/Hastings",
"6435500", "Christchurch",
"6435531", "Nelson",
"6479719", "Te\ Kuiti",
"6472829", "Tauranga",
"646846", "Napier\ City",
"6479841", "Huntly",
"6477778", "Te\ Awamutu",
"6439289", "Akaroa",
"6473948", "Opotiki",
"6439295", "Nelson",
"646750", "Mokau",
"6435514", "Palmerston",
"6479029", "Waihi",
"6475605", "Huntly",
"6469573", "Palmerston\ North",
"6439273", "Blenheim",
"6462165", "Stratford",
"6434241", "Rangiora",
"6436992", "Greymouth",
"649406", "Kaitaia",
"6499552", "Dargaville",
"649391", "Auckland",
"649407", "Kaikohe",
"6439098", "Akaroa",
"643680", "Fairlie",
"6478997", "Morrinsville",
"646365", "Palmerston\ North",
"643485", "Lawrence",
"6432735", "Mt\ Cook",
"6466522", "Palmerston\ North",
"643393", "Christchurch",
"643269", "South\ Island",
"6435881", "Dunedin",
"6479751", "Tauranga",
"6479242", "Rotorua",
"6433988", "Wanaka",
"6479249", "Huntly",
"6439767", "Alexandra",
"6439881", "Greymouth",
"6466529", "Pahiatua",
"6497771", "Kaikohe",
"647864", "Thames",
"6499559", "Whangarei",
"646760", "New\ Plymouth\/Opunake\/Stratford",
"6499013", "Kawakawa",
"6474639", "Opotiki",
"6436999", "Nelson",
"6466005", "Mokau",
"649423", "Warkworth",
"6472221", "Tauranga",
"6437774", "Queenstown",
"6434359", "Twizel",
"6435696", "Haast",
"644590", "Wellington",
"6433944", "Ashburton",
"643421", "Christchurch",
"6432650", "Christchurch",
"6478081", "Rotorua",
"6432660", "Christchurch",
"6463915", "Opunake",
"6469012", "Waiouru",
"6439084", "Amberley",
"6435509", "Culverden",
"6496507", "Helensville",
"6439459", "Tokanui",
"6434291", "Westport",
"6472820", "Hamilton",
"6479710", "Putaruru\/Tokoroa",
"6469202", "Levin",
"6434236", "Amberley",
"6469316", "Dannevirke",
"6495562", "Whangarei",
"6439048", "Lawrence",
"6439280", "Nelson",
"6462812", "Napier\/Hastings",
"6479292", "Hamilton",
"6432723", "Takaka",
"6469716", "Opunake",
"6439757", "Waitangi\ \(Chatham\ Is\.\)",
"6479020", "Te\ Awamutu",
"646653", "Wanganui",
"6493936", "Maungaturoto",
"6468808", "Palmerston\ North",
"6468243", "Napier",
"6493991", "Pukekohe",
"6439025", "Otautau",
"6479299", "Rotorua",
"6437486", "Tokanui",
"6436577", "Cromwell",
"647462", "Taupo",
"6462819", "Levin",
"6432997", "Edendale",
"6495569", "Maungaturoto",
"6436567", "Ranfurly",
"6432611", "Kaikoura",
"649405", "Kaikohe",
"647315", "Opotiki",
"647869", "Thames",
"6433916", "Hokitika",
"6439715", "Timaru",
"6435502", "Christchurch",
"64732", "Whakatane",
"6439452", "Gore",
"6462155", "Hawera",
"646860", "Gisborne\/Ruatoria",
"6432227", "Queenstown",
"6469019", "Pahiatua",
"6432634", "Invercargill",
"6433994", "Winton",
"6477884", "Tauranga",
"6439315", "Tokanui",
"643758", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"64480", "Wellington",
"6442821", "Wellington",
"6479240", "Taupo",
"6473933", "Rotorua",
"6466520", "Palmerston\ North",
"6468815", "Pahiatua",
"6442608", "Paraparaumu",
"643944", "Christchurch",
"6478097", "Whakatane",
"646845", "Napier\/Hastings",
"6442125", "Paraparaumu",
"649320", "Auckland",
"6462603", "Palmerston\ North",
"6469246", "Palmerston\ North",
"6436990", "Cheviot",
"6439708", "Murchison",
"6432446", "Blenheim",
"6434350", "Twizel",
"647926", "Tauranga",
"6432659", "Takaka",
"644280", "Wellington",
"6434287", "Queenstown",
"647927", "Tauranga",
"6432652", "Cromwell",
"6435998", "Rangiora",
"6468255", "Pahiatua",
"6463908", "Wairoa",
"6462627", "Wanganui",
"6435546", "Greymouth",
"6432758", "Otautau",
"649959", "Hibiscus\ Coast",
"6473998", "Taumarunui",
"644205", "Wellington",
"647903", "Hamilton",
"6472428", "Taupo",
"6436548", "Waimate",
"64796", "Hamilton",
"6435699", "Amberley",
"6432440", "Christchurch",
"6435685", "Tokanui",
"6492807", "Helensville",
"6469240", "Gisborne",
"6436996", "Takaka",
"6437445", "Fox\ Glacier",
"643246", "Tokanui",
"6499556", "Maungaturoto",
"643956", "Timaru",
"643247", "Tokanui\/Lumsden\/Te\ Anau",
"643957", "Timaru",
"6466526", "Waiouru",
"649392", "Auckland",
"6436584", "Winton",
"6499007", "Kaikohe",
"6472603", "Hamilton",
"6479246", "Thames",
"6466995", "Opunake",
"643430", "Mt\ Cook",
"6472627", "Rotorua",
"64336", "South\ Island",
"646903", "Palmerston\ North",
"6436525", "Franz\ Josef",
"6435540", "Edendale",
"6439333", "Franz\ Josef",
"6472143", "Morrinsville",
"6439067", "Franz\ Josef",
"6435692", "Takaka",
"6439733", "Te\ Anau",
"6463998", "Palmerston\ North",
"6439077", "Ashburton",
"6469710", "New\ Plymouth",
"6479026", "Paeroa",
"6495", "Auckland",
"6439286", "Cromwell",
"6436684", "Dunedin",
"6432424", "Nelson",
"647982", "Hamilton",
"6439524", "Oamaru",
"6469310", "Wanganui",
"6479716", "Waihi",
"6469020", "Stratford",
"6434230", "Christchurch",
"6437453", "Amberley",
"6436648", "Lumsden",
"64795", "Hamilton",
"6472826", "Matamata",
"6469292", "Ruatoria",
"6469304", "Wairoa",
"644650", "Wellington",
"6499747", "Dargaville",
"6439878", "Christchurch\/Blenheim\/Nelson",
"6472812", "Tauranga",
"6439868", "Blenheim",
"6466551", "New\ Plymouth",
"6432666", "South\ Island",
"6498019", "Pukekohe",
"6436625", "Rangiora",
"646869", "Gisborne\/Ruatoria",
"6469285", "Hawera",
"644888", "Wellington",
"6472819", "Rotorua",
"643219", "Invercargill",
"6434274", "Kurow",
"6469299", "Napier\/Hastings",
"6492008", "Hibiscus\ Coast",
"6434264", "Kurow",
"6475628", "Tauranga",
"6433910", "Nelson",
"646764", "Stratford",
"647860", "Paeroa\/Waihi\/Thames\/Whangamata",
"6478134", "Taumarunui",
"6479019", "Whangamata",
"6437480", "Gore",
"6499", "Auckland",
"64632", "Palmerston\ North",
"6474444", "Hamilton",
"6493930", "Whangarei",
"64335", "Christchurch",
"6462418", "Palmerston\ North",
"643260", "Christchurch",
"6465605", "Marton",
"643689", "Waimate",
"6468825", "Gisborne",
"6439008", "Timaru",
"6468307", "Napier\/Wairoa",
"647533", "Tauranga",
"6469242", "Levin",
"6432442", "Christchurch",
"6468997", "Napier",
"6435549", "Hokitika",
"64934", "Auckland\/Waiheke\ Island",
"6432808", "Westport",
"6436633", "Geraldine",
"6432656", "Nelson",
"6462617", "Masterton",
"643214", "Invercargill",
"6439858", "Kaikoura",
"647828", "Huntly",
"6433951", "Timaru",
"6435690", "Motueka",
"646864", "Ruatoria",
"6468884", "Palmerston\ North",
"6437473", "Milton",
"644570", "Wellington",
"6435542", "Riverton",
"6432449", "Queenstown",
"6499068", "Pukekohe",
"6437463", "Mt\ Cook",
"6469249", "Masterton",
"643409", "Queenstown",
"6462221", "Gisborne",
"646769", "New\ Plymouth",
"6478078", "Whangamata",
"6432747", "Queenstown",
"6436598", "Wanaka",
"6479004", "Te\ Awamutu",
"6439348", "South\ Island",
"6472810", "Tauranga",
"6439057", "Waimate",
"6469016", "Ohakune",
"6499877", "Maungaturoto",
"6439748", "Dunedin",
"6463925", "Waiouru",
"6469290", "Napier\/Hastings",
"6434232", "Ashburton",
"6469022", "Hawera",
"6469312", "Ohakune",
"644904", "Paraparaumu",
"6495566", "Kaikohe",
"6432713", "Ashburton",
"643940", "Christchurch",
"6433919", "Haast",
"6472804", "Whangamata",
"643250", "Christchurch",
"6462127", "Dannevirke",
"6479010", "Thames",
"6469618", "Wanganui\/New\ Plymouth",
"6462816", "Gisborne",
"6479296", "Tauranga",
"6437489", "South\ Island",
"6469712", "New\ Plymouth",
"6493939", "Auckland",
"6493932", "Dargaville",
"6432621", "Oamaru",
"6437482", "Lumsden",
"6465618", "Masterton",
"64483", "Wellington",
"6462103", "Levin",
"6439015", "Wanaka",
"644619", "Wellington",
"6479854", "Rotorua",
"643955", "Dunedin",
"6469319", "Masterton",
"643245", "Tokanui\/Lumsden\/Te\ Anau",
"6433912", "Motueka",
"6469029", "Opunake",
"6434239", "Christchurch",
"6435506", "Amberley",
"6492835", "Kaikohe",
"6439325", "Kaikoura",
"6439456", "Riverton",
"647218", "Tauranga",
"6467778", "Wairoa",
"6439725", "Christchurch",
"6432815", "Fairlie",
"6496513", "Whangarei",
"6498854", "Hibiscus\ Coast",
"6472193", "Whakatane",
"6499455", "Dargaville",
"6437460", "Waitangi\ \(Chatham\ Is\.\)",
"647881", "Matamata",
"6437470", "Balclutha",
"6439332", "Hokitika",
"64340", "South\ Island",
"6439732", "Otautau",
"6435693", "Nelson",
"6472142", "Te\ Awamutu",
"6436630", "Takaka",
"643442", "Queenstown",
"6434248", "Cheviot",
"6499726", "Kawakawa",
"6472609", "Whangamata",
"6439091", "Rangiora",
"6434284", "Wanaka",
"6473339", "Taupo",
"6478094", "Tauranga",
"6469275", "Wanganui",
"6435888", "Timaru",
"644887", "Wellington",
"643983", "Christchurch",
"6499016", "Kaikohe",
"644886", "Wellington",
"6462624", "Opunake",
"6497778", "Pukekohe",
"64368", "Timaru",
"647825", "Hamilton",
"6433981", "Twizel",
"6439888", "Christchurch\/Blenheim\/Nelson",
"6473332", "Rotorua",
"643226", "Otautau",
"6443709", "Paraparaumu",
"6472602", "Hamilton",
"6434995", "Te\ Anau",
"646946", "Masterton",
"6439266", "Dunedin",
"649349", "Auckland",
"6469576", "Dannevirke",
"6439276", "Nelson",
"6439739", "Invercargill",
"6472149", "Whangamata",
"6439339", "South\ Island",
"6499719", "Whangarei",
"6434225", "Edendale",
"6447770", "Paraparaumu",
"64634", "Wanganui",
"647391", "Hamilton",
"644890", "Wellington",
"6462100", "Levin",
"64675", "New\ Plymouth",
"64372", "South\ Island",
"6432887", "Nelson",
"6462114", "Waipukurau",
"6466011", "Marton",
"6472190", "Whakatane",
"6439754", "Darfield",
"6498825", "Maungaturoto",
"6496510", "Whangarei",
"6439538", "Dunedin\/Timaru",
"646371", "Masterton\/Dannevirke\/Pahiatua",
"6437459", "Rangiora",
"6436501", "Akaroa",
"6475611", "Taumarunui",
"6437452", "Akaroa",
"6432994", "Otautau",
"6436564", "Milton",
"6469293", "New\ Plymouth",
"6472813", "Waihi",
"643248", "Lumsden",
"6478128", "Huntly",
"6435538", "Lumsden",
"643958", "Dunedin\/Timaru",
"6434401", "Cromwell",
"6479848", "Te\ Kuiti",
"647215", "Rotorua",
"6477771", "Whakatane",
"6432224", "Invercargill",
"6435665", "Waimate",
"6477887", "Te\ Awamutu",
"6432637", "Winton",
"6433997", "Gore",
"6435675", "Twizel",
"6472459", "Rotorua",
"6432710", "Christchurch",
"6475825", "Hamilton",
"644834", "Paraparaumu",
"6443990", "Paraparaumu",
"647217", "Taupo",
"6462421", "New\ Plymouth",
"64349", "South\ Island",
"647216", "Rotorua",
"644211", "Wellington",
"6478994", "Tauranga",
"6439701", "Nelson",
"6436632", "Murchison",
"6472140", "Putaruru\/Tokoroa",
"6439730", "Invercargill",
"6435543", "Tokanui",
"6439330", "Westport",
"6437472", "Lawrence",
"64685", "Waipukurau",
"6437462", "Geraldine",
"6444888", "Paraparaumu",
"6469243", "New\ Plymouth",
"6462606", "Waiouru",
"64932", "Auckland\/Waiheke\ Island",
"6463901", "Gisborne",
"6437469", "Alexandra",
"6472614", "Otorohanga",
"6435991", "Franz\ Josef",
"6432443", "Christchurch",
"6437479", "Edendale",
"6439764", "Lawrence",
"6436639", "Oamaru",
"6432751", "Riverton",
"6437777", "Christchurch",
"6499299", "Whangarei",
"6433947", "Darfield",
"6472600", "Hamilton",
"6473991", "Whakatane",
"646960", "Wanganui\/New\ Plymouth",
"643413", "Balclutha",
"6469007", "Masterton",
"6474657", "Thames",
"6499044", "Hibiscus\ Coast",
"6434298", "Hokitika",
"6496512", "Whangarei",
"64686", "Gisborne",
"6472192", "Whakatane",
"6436654", "Tokanui",
"6468246", "Hawera",
"6493933", "Kaikohe",
"647332", "Rotorua",
"6437483", "Otautau",
"6439041", "Ashburton",
"6472124", "Matamata",
"6462807", "Napier\/Hastings",
"643225", "Otautau",
"643520", "Blenheim",
"6435555", "Timaru",
"647826", "Huntly",
"6462102", "Levin",
"6433913", "Murchison",
"643749", "Christchurch",
"647827", "Hamilton",
"6432719", "Waitangi\ \(Chatham\ Is\.\)",
"6432712", "Amberley",
"6469313", "Marton",
"6465621", "New\ Plymouth",
"6468801", "Wanganui",
"6462109", "Waiouru",
"643920", "Rangiora",
"6432618", "Culverden",
"649452", "Auckland",
"6432726", "Franz\ Josef",
"646950", "Palmerston\ North\/New\ Plymouth",
"6469713", "Stratford",
"6472199", "Opotiki",
"64948", "Auckland",
"6435517", "Lawrence",
"6496519", "Maungaturoto",
"6499475", "Hibiscus\ Coast",
"6496995", "Maungaturoto",
"6434233", "Rangiora",
"6499465", "Dargaville",
"6437450", "Westport",
"6499874", "Kawakawa",
"643740", "Christchurch",
"646320", "Palmerston\ North\/Marton",
"6479007", "Whakatane",
"643529", "Nelson",
"6492428", "Hibiscus\ Coast",
"6436641", "Lawrence",
"6462124", "Marton",
"6472807", "Te\ Awamutu",
"6439861", "Nelson",
"6466558", "Opunake",
"6498815", "Helensville",
"6439871", "Queenstown",
"6472823", "Whakatane",
"6437456", "Culverden",
"6479713", "Morrinsville",
"6479857", "Opotiki",
"6475621", "Tauranga",
"649408", "Kaitaia",
"6432663", "Christchurch",
"6498857", "Dargaville",
"6432720", "Nelson",
"646959", "Palmerston\ North\/New\ Plymouth",
"643755", "Hokitika",
"6439283", "Rangiora",
"6439336", "Cromwell",
"643441", "Queenstown",
"6499716", "Helensville",
"6439736", "Riverton",
"6439279", "Christchurch",
"6472146", "Otorohanga",
"647882", "Putaruru\/Tokoroa",
"6469579", "Pahiatua",
"6439269", "Dunedin",
"6479747", "Te\ Kuiti",
"64343", "Oamaru",
"64785", "Hamilton",
"646848", "Napier\ City",
"644894", "Wellington",
"6468304", "Napier\/Wairoa",
"6499012", "Kawakawa",
"64347", "Dunedin",
"6468994", "Waipukurau",
"643233", "Riverton\/Winton",
"6499019", "Maungaturoto",
"6499553", "Kaikohe",
"646969", "New\ Plymouth",
"6466523", "Palmerston\ North",
"6462614", "Wairoa",
"6473930", "Waihi",
"6479243", "Rotorua\/Whakatane\/Tauranga",
"6472606", "Huntly",
"6468887", "Gisborne",
"6469572", "Palmerston\ North",
"6442420", "Wellington",
"6439272", "Timaru",
"643651", "Nelson",
"6432744", "Ranfurly",
"6434353", "Twizel",
"6463991", "Masterton",
"6498", "Auckland",
"6462600", "Palmerston\ North",
"6436993", "Kaikoura",
"6436687", "Nelson",
"6439341", "Fairlie",
"6432427", "Greymouth",
"6439527", "Kurow",
"643571", "Nelson",
"6439453", "Te\ Anau",
"6436591", "Nelson",
"6435503", "Christchurch",
"6496516", "Kaikohe",
"6439741", "Christchurch",
"6472196", "Taupo",
"64734", "Rotorua",
"6472131", "Rotorua",
"6469307", "Stratford",
"6432645", "Greymouth",
"6468242", "Ruatoria",
"6474648", "Huntly",
"6469611", "Wanganui",
"6432729", "Westport",
"6462106", "Pahiatua",
"64354", "Nelson",
"6432628", "Ranfurly",
"64325", "South\ Island",
"6434277", "Ranfurly",
"6495563", "Whangarei",
"647873", "Otorohanga",
"649451", "Auckland",
"6432716", "Darfield",
"647928", "Tauranga",
"6462813", "Wanganui",
"646964", "Wanganui",
"6434267", "Ranfurly",
"6432722", "Murchison",
"6479293", "Hamilton",
"6465611", "Napier",
"643453", "Dunedin",
"6468249", "Opunake",
"6474447", "Te\ Kuiti",
"6469203", "New\ Plymouth",
"6478137", "Thames",
"6435527", "Alexandra",
"6467771", "New\ Plymouth",
"6463941", "Masterton",
"643757", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6499010", "Kaitaia",
"643756", "Hokitika",
"6462411", "New\ Plymouth",
"6439001", "Christchurch",
"643524", "Takaka",
"6499296", "Kaitaia",
"6442429", "Paraparaumu",
"6436636", "Waimate",
"6432653", "Wanaka",
"6495589", "Pukekohe",
"6499004", "Hibiscus\ Coast",
"6436587", "Gore",
"644212", "Wellington",
"6437476", "Ranfurly",
"6432801", "Lumsden",
"6462609", "Pahiatua",
"6437466", "Cromwell",
"6462602", "Palmerston\ North",
"6439851", "Culverden",
"6433958", "Oamaru",
"6439270", "Greymouth",
"6472624", "Whakatane",
"6499061", "Hibiscus\ Coast",
"6469570", "Palmerston\ North",
"6439064", "Ashburton",
"646954", "Palmerston\ North\ W100",
"6462228", "Wanganui",
"643924", "Christchurch",
"6475958", "Taupo",
"6439074", "Ashburton",
"6473932", "Rotorua",
"643463", "Palmerston",
"6462149", "Ruatoria",
"6478071", "Otorohanga",
"6469617", "Wanganui\/New\ Plymouth",
"6435", "South\ Island",
"6469301", "Ruatoria",
"6468813", "Taihape",
"6466554", "Hawera",
"6473935", "Rotorua",
"6462128", "Ohakune",
"6498901", "Pukekohe",
"644975", "Paraparaumu",
"647867", "Thames",
"6439521", "Dunedin",
"6462605", "Marton",
"6439347", "Christchurch",
"6432421", "Tokanui\/Lumsden\/Te\ Anau",
"6436681", "Dunedin",
"647866", "Thames",
"6436597", "Cromwell",
"6493209", "Great\ Barrier\ Island",
"6439747", "Wanaka",
"6499878", "Warkworth",
"6474441", "Waihi",
"6468253", "Marton",
"649404", "Kawakawa",
"6467777", "Napier",
"6478131", "Otorohanga",
"6434271", "Balclutha",
"6434261", "Balclutha",
"64935", "Auckland",
"6499100", "Pukekohe",
"6465617", "Mokau",
"6432606", "Dunedin",
"6468998", "Napier",
"643436", "Kurow",
"6463913", "Hawera",
"6436581", "Invercargill",
"6496996", "Warkworth",
"6432807", "Tokanui",
"6499466", "Kaikohe",
"649957", "Pukekohe",
"646844", "Napier\/Hastings",
"6462417", "Wanganui",
"6432725", "Hokitika",
"6439007", "Dunedin",
"6432649", "Waimate",
"643392", "South\ Island",
"6468245", "Wairoa",
"6432642", "Fox\ Glacier",
"6439023", "Te\ Anau",
"6496009", "Pukekohe",
"6432748", "Cromwell",
"6435556", "Fairlie",
"649470", "Whangarei",
"644666", "Wellington",
"64936", "Auckland",
"6478077", "Waihi",
"643240", "Tokanui\/Lumsden\/Te\ Anau",
"649422", "Warkworth",
"644204", "Wellington",
"6439713", "Mt\ Cook",
"643950", "Dunedin",
"6462153", "New\ Plymouth",
"6439857", "Akaroa",
"6462618", "Masterton",
"6439313", "Te\ Anau",
"6499067", "Pukekohe",
"6499733", "Warkworth",
"6475603", "Hamilton",
"6472118", "Taumarunui",
"64376", "Greymouth",
"6469575", "Waiouru",
"6436647", "Te\ Anau",
"6439275", "Nelson",
"6444", "Wellington",
"6439867", "Christchurch\/Blenheim\/Nelson",
"6462163", "New\ Plymouth",
"6472801", "Huntly",
"6439877", "Christchurch\/Blenheim\/Nelson",
"6499748", "Whangarei",
"6434226", "Lumsden",
"646849", "Napier\ City",
"644589", "Wellington",
"6479001", "Hamilton",
"6432733", "Geraldine",
"6434996", "Roxburgh",
"646968", "New\ Plymouth\ W100",
"6498851", "Pukekohe",
"647463", "Whakatane",
"6469276", "Wanganui",
"6449031", "Paraparaumu",
"6499015", "Dargaville",
"643946", "Invercargill",
"6466003", "Ruatoria",
"6499456", "Kaikohe",
"643947", "Invercargill",
"644209", "Wellington",
"6479851", "Waihi",
"6475627", "Taupo",
"6492007", "Warkworth",
"643435", "Oamaru\/Mount\ Cook\/Twizel\/Kurow",
"6499725", "Hibiscus\ Coast",
"6432624", "Milton",
"6435666", "Oamaru",
"6435676", "Kurow",
"6473923", "Otorohanga",
"643331", "Christchurch",
"644576", "Wellington",
"6499008", "Pukekohe",
"644577", "Wellington",
"6475826", "Hamilton",
"643528", "Motueka",
"64754", "Tauranga",
"6436547", "Geraldine",
"6496014", "Dargaville",
"6472427", "Rotorua",
"6492", "Auckland",
"6492808", "Great\ Barrier\ Island",
"64334", "Christchurch",
"6468263", "Napier",
"643267", "South\ Island",
"6498826", "Warkworth",
"6463997", "Palmerston\ North",
"649409", "Kaitaia",
"647865", "Whangamata",
"6439078", "Ashburton",
"6436613", "Wanaka",
"6449740", "Paraparaumu",
"6462224", "Masterton",
"6439068", "Fox\ Glacier",
"6472628", "Taupo",
"646958", "Palmerston\ North\/New\ Plymouth",
"6499421", "Hibiscus\ Coast",
"6439293", "Blenheim",
"6433954", "Lawrence",
"6432640", "Hokitika",
"6468881", "Napier\/Hastings",
"6439707", "Takaka",
"6448880", "Paraparaumu",
"6499631", "Pukekohe",
"6435884", "Dunedin",
"6479754", "Tauranga",
"6499472", "Great\ Barrier\ Island",
"6496992", "Kawakawa",
"646767", "New\ Plymouth\/Opunake\/Stratford",
"6434288", "Cromwell",
"6463923", "Ohakune",
"6499462", "Whangarei",
"646766", "New\ Plymouth",
"6434244", "Amberley",
"6432715", "Culverden",
"6475820", "Hamilton",
"6435559", "Haast",
"6435670", "Palmerston",
"6435660", "Haast",
"6433941", "Blenheim",
"6437771", "Blenheim",
"6472224", "Taupo",
"643215", "Invercargill",
"6432646", "Timaru",
"6473997", "Te\ Kuiti",
"6462105", "Taihape",
"6435552", "Queenstown",
"6439013", "Ashburton",
"6499469", "Maungaturoto",
"649400", "Kaikohe",
"6463907", "Waipukurau",
"6499479", "Pukekohe",
"6439323", "Cheviot",
"6492833", "Warkworth",
"6478140", "Rotorua",
"6435997", "Amberley",
"6439723", "Blenheim",
"649421", "Hibiscus\ Coast",
"6439884", "Franz\ Josef",
"6498820", "Whangarei",
"6496515", "Dargaville",
"6432813", "Geraldine",
"64694", "Masterton\/Levin",
"6497774", "Warkworth",
"6432757", "Lumsden",
"6493944", "Hibiscus\ Coast",
"6462628", "Wanganui",
"6472195", "Rotorua",
"6434990", "Queenstown",
"6432609", "Mt\ Cook",
"6462801", "Palmerston\ North",
"6439047", "Alexandra",
"647983", "Hamilton",
"6439534", "Mt\ Cook",
"6439758", "Ashburton",
"6435560", "Mt\ Cook",
"6468823", "Napier\/Hastings",
"6465603", "Palmerston\ North",
"6462118", "Waipukurau",
"646840", "Napier\ City",
"6434220", "Invercargill",
"644905", "Paraparaumu",
"6474651", "Otorohanga",
"64931", "Auckland\/Waiheke\ Island",
"6469001", "New\ Plymouth",
"6496508", "Hibiscus\ Coast",
"6436635", "Fairlie",
"6435511", "Kaikoura",
"6437475", "Palmerston",
"6495531", "Helensville",
"6493206", "Pukekohe",
"6437465", "Waimate",
"6499450", "Warkworth",
"6479844", "Otorohanga",
"643954", "Dunedin\/Timaru",
"6432228", "Wanaka",
"643690", "Waimate",
"6469270", "Marton",
"6435534", "Takaka",
"6468807", "Gisborne",
"6465627", "Levin",
"6436568", "Roxburgh",
"6469851", "Napier",
"6499295", "Kaikohe",
"6432998", "Tokanui",
"6436578", "Wanaka",
"643332", "Christchurch",
"6435662", "Geraldine",
"6439097", "Darfield",
"6435672", "Balclutha",
"6478998", "Hamilton",
"6499460", "Whangarei",
"6437455", "Cheviot",
"6496990", "Kaitaia",
"6499470", "Hibiscus\ Coast",
"6446509", "Paraparaumu",
"6436623", "Amberley",
"6498822", "Kaikohe",
"6469283", "Opunake",
"643959", "Dunedin\/Timaru",
"6478142", "Whakatane",
"643249", "Te\ Anau",
"6498816", "Great\ Barrier\ Island",
"644906", "Paraparaumu",
"6475829", "Hamilton",
"6435550", "Fox\ Glacier",
"6439768", "Ranfurly",
"6433987", "Cromwell",
"6435679", "Alexandra",
"64371", "South\ Island",
"647920", "Rotorua",
"649439", "Dargaville",
"6435669", "Wanaka",
"6466017", "Napier",
"643480", "Dunedin\/Lawrence\/Mosgiel",
"643685", "Fairlie",
"6472128", "Waihi",
"6435683", "Te\ Anau",
"6434222", "Gore",
"6436507", "Kaikoura",
"6499459", "Maungaturoto",
"6462137", "Palmerston\ North",
"6436658", "Fox\ Glacier",
"6437443", "Nelson",
"6435562", "Invercargill",
"6469279", "Levin",
"6499048", "Pukekohe",
"6434294", "Franz\ Josef",
"646866", "Gisborne\/Ruatoria",
"643217", "Invercargill",
"6478084", "Hamilton",
"643216", "Invercargill",
"6472605", "Thames",
"6434992", "Ranfurly",
"6435650", "Greymouth",
"6473947", "Whakatane",
"6466993", "Waiouru",
"6434999", "Dunedin",
"6477777", "Hamilton",
"644595", "Wellington",
"6433991", "Invercargill",
"6432631", "Gore",
"6477881", "Hamilton",
"646651", "Napier",
"6469272", "Featherston",
"646765", "Stratford",
"6434229", "Winton",
"6499452", "Warkworth",
"649348", "Auckland",
"6442197", "Paraparaumu",
"6475617", "Whakatane",
"6439335", "Haast",
"6432614", "South\ Island",
"6436523", "Hokitika",
"6472145", "Huntly",
"6439735", "Lumsden",
"6492227", "Whangarei",
"6434407", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6439716", "Geraldine",
"6436588", "Lumsden",
"6462156", "Hawera",
"6468991", "Gisborne",
"6492832", "Dargaville",
"6439322", "Culverden",
"6432812", "Haast",
"6469280", "Waipukurau",
"6439722", "Blenheim",
"643443", "Wanaka",
"6436620", "Kaikoura",
"6439316", "Edendale",
"6439026", "Riverton",
"6493935", "Kawakawa",
"6437485", "Te\ Anau",
"64943", "Whangarei",
"643231", "Invercargill",
"6439012", "Queenstown",
"643982", "Christchurch",
"64947", "Auckland",
"6435553", "Wanaka",
"6472424", "Tauranga",
"6496017", "Great\ Barrier\ Island",
"6433915", "Greymouth",
"6469315", "Taihape",
"6463994", "Dannevirke",
"6439019", "Roxburgh",
"644777", "Wellington",
"6462227", "Napier",
"6479100", "Rotorua",
"6432741", "Milton",
"64735", "Rotorua",
"6469715", "Mokau",
"6463916", "Mokau",
"6433957", "Palmerston",
"6462611", "Napier",
"6432819", "Christchurch",
"6439729", "Fox\ Glacier",
"6463922", "Palmerston\ North",
"6439329", "South\ Island",
"6499473", "Helensville",
"6496993", "Whangarei",
"6492839", "Whangarei",
"6469025", "Mokau",
"6434235", "Akaroa",
"6499463", "Whangarei",
"643653", "Blenheim",
"6462121", "Palmerston\ North",
"6439864", "Takaka",
"6465609", "Pahiatua",
"6439874", "Cromwell",
"6469308", "Opunake",
"64423", "Wellington",
"6436644", "Alexandra",
"6466990", "Mokau",
"6468256", "Palmerston\ North",
"64396", "Christchurch",
"6439528", "Lawrence",
"643224", "Invercargill",
"6432428", "Queenstown",
"6436688", "Waitangi\ \(Chatham\ Is\.\)",
"6436520", "Greymouth",
"6435545", "Gore",
"644551", "Paraparaumu",
"647829", "Hamilton",
"646832", "Napier\/Wairoa",
"6474448", "Taumarunui",
"6432445", "Greymouth",
"6435680", "Dunedin",
"6478138", "Waihi",
"6435528", "Ranfurly",
"646327", "Marton",
"6475624", "Rotorua",
"6434268", "Roxburgh",
"6499810", "Hibiscus\ Coast",
"6432627", "Alexandra",
"646768", "New\ Plymouth",
"6434278", "Roxburgh",
"6468816", "Hawera",
"64736", "Rotorua",
"647557", "Tauranga",
"6437440", "Nelson",
"6465602", "Palmerston\ North",
"6468822", "Masterton",
"6432804", "Riverton",
"6466508", "Napier\/Wairoa",
"6439010", "Queenstown",
"6479109", "Opotiki",
"6439296", "Invercargill",
"649347", "Auckland",
"6436622", "Cheviot",
"6439004", "Gore",
"6439720", "Blenheim",
"646949", "Levin\ W100",
"6432810", "Franz\ Josef",
"6498823", "Kaitaia",
"6469282", "Mokau",
"6436616", "Geraldine",
"6478143", "Opotiki",
"6439320", "Akaroa",
"6479748", "Taumarunui",
"6462414", "Napier",
"643750", "Haast",
"643218", "Invercargill",
"647824", "Hamilton",
"644889", "Wellington",
"6478074", "Taumarunui",
"6469295", "Wanganui",
"6463920", "Palmerston\ North",
"6472815", "Whakatane",
"6469289", "Taihape",
"6439061", "Greymouth",
"6436629", "Christchurch",
"6439071", "Motueka",
"6435663", "Twizel",
"6499428", "Warkworth",
"643461", "Dunedin\/Palmerston",
"6473926", "Taumarunui",
"6499064", "Helensville",
"6435673", "Lawrence",
"6472621", "Tauranga",
"6479102", "Rotorua",
"6468888", "Masterton",
"647245", "Hamilton",
"6475823", "Hamilton",
"6439854", "Waitangi\ \(Chatham\ Is\.\)",
"643412", "Balclutha",
"6499453", "Warkworth",
"6466006", "Opunake",
"64363", "South\ Island",
"6436522", "Greymouth",
"6435689", "Otautau",
"6492427", "Warkworth",
"6435695", "Fox\ Glacier",
"6469614", "Levin",
"6472808", "Putaruru\/Tokoroa",
"6466557", "Stratford",
"64367", "South\ Island",
"6499819", "Helensville",
"6466992", "Hawera",
"644908", "Paraparaumu",
"6439744", "Queenstown",
"6469273", "New\ Plymouth",
"6439344", "Timaru",
"6479008", "Rotorua",
"6498690", "Kawakawa",
"6437449", "Hokitika",
"6436594", "Waimate",
"6465600", "Palmerston\ North",
"6479421", "Tauranga",
"6468820", "Palmerston\ North",
"6437442", "Murchison",
"6463944", "Featherston",
"6498858", "Kaikohe",
"6435563", "Queenstown",
"643451", "Queenstown",
"6467774", "Dannevirke",
"6432736", "Dunedin",
"647871", "Te\ Awamutu",
"6434993", "Alexandra",
"649902", "Warkworth",
"6466999", "New\ Plymouth",
"64784", "Hamilton",
"6475606", "Matamata",
"6479858", "Whakatane",
"6465614", "Wanganui",
"6436529", "Westport",
"6435682", "Riverton",
"6462166", "Opunake",
"6434223", "Otautau",
"6462808", "Napier\/Hastings",
"6436504", "Cheviot",
"6466014", "Napier",
"6468819", "Mokau",
"6439751", "Culverden",
"6469008", "Palmerston\ North",
"6468252", "Dannevirke",
"6474658", "Waihi",
"6432655", "Nelson",
"64369", "Geraldine",
"6442129", "Paraparaumu",
"6434297", "Westport",
"6466000", "Napier",
"644897", "Wellington",
"6435518", "Milton",
"644896", "Wellington",
"6462160", "Masterton",
"6498881", "Hibiscus\ Coast",
"646965", "Wanganui\ W100",
"6473944", "Tauranga",
"6477774", "Thames",
"6432221", "Nelson",
"6468259", "Levin",
"6475600", "Hamilton",
"649958", "Helensville",
"6434404", "Alexandra",
"6432730", "Blenheim",
"6468812", "Waiouru",
"6432991", "Milton",
"6475614", "Thames",
"643438", "Kurow",
"646214", "Gisborne",
"6465606", "Waiouru",
"6436561", "Oamaru",
"6432617", "Cheviot",
"6468826", "Levin",
"64731", "Whakatane\/Opotiki",
"6478091", "Matamata",
"6439712", "Fairlie",
"6439455", "Otautau",
"6462152", "New\ Plymouth",
"6436610", "Kaikoura",
"6492836", "Kaitaia",
"6479500", "Whakatane",
"6435505", "Akaroa",
"6439326", "Rangiora",
"647883", "Putaruru\/Tokoroa",
"643525", "Takaka",
"6432816", "Waimate",
"6444887", "Paraparaumu",
"6439726", "Timaru",
"6439094", "Ashburton",
"6434281", "Queenstown",
"6439312", "Riverton",
"6432643", "Haast",
"6439022", "Ashburton",
"643981", "Christchurch",
"6439290", "Christchurch",
"6439016", "Alexandra",
"647949", "Hamilton",
"647325", "Opotiki",
"643232", "Riverton\/Winton",
"6495565", "Dargaville",
"6433948", "Kaikoura",
"6462815", "Wairoa",
"6437778", "Greymouth",
"6473920", "Huntly",
"6479295", "Whakatane",
"647868", "Thames",
"6439029", "Tokanui",
"64391", "South\ Island",
"6463912", "New\ Plymouth",
"6468260", "Featherston",
"6439319", "Otautau",
"646955", "Palmerston\ North\/New\ Plymouth",
"643925", "Christchurch",
"6463926", "Taihape",
"649652", "Warkworth",
"6462159", "Mokau",
"6462621", "New\ Plymouth",
"6439719", "Waimate",
"643759", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6433984", "Roxburgh",
"6439537", "Dunedin\/Timaru",
"6466002", "Napier",
"6436526", "Fox\ Glacier",
"6479708", "Thames",
"6432888", "Nelson",
"6462169", "Featherston",
"643926", "Christchurch",
"643411", "Balclutha\/Milton",
"6472121", "Te\ Kuiti",
"6439044", "Milton",
"646956", "Palmerston\ North\/New\ Plymouth",
"6475609", "Paeroa",
"6468250", "Stratford",
"6499041", "Helensville",
"6466996", "Stratford",
"64360", "South\ Island",
"6432739", "Balclutha",
"6436651", "Riverton",
"64429", "Paraparaumu",
"6466548", "Ruatoria",
"643268", "South\ Island",
"647872", "Te\ Awamutu",
"6437446", "Franz\ Josef",
"6477888", "Taupo",
"6499555", "Kawakawa",
"6432638", "Tokanui",
"6433998", "Lumsden",
"6479847", "Te\ Awamutu",
"6466525", "Marton",
"6468810", "Ohakune",
"6432732", "Fairlie",
"643903", "Christchurch",
"6479245", "Matamata",
"643452", "Wanaka",
"6436519", "Takaka",
"6475602", "Hamilton",
"643527", "Motueka",
"64636", "Levin",
"643526", "Motueka",
"64348", "Dunedin",
"643754", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6435686", "Gore",
"6462162", "Masterton",
"647820", "Hamilton\/Huntly",
"6466009", "Waiouru",
"6465624", "Featherston",
"6468804", "Napier",
"6436995", "Westport",
"6435537", "Winton",
"643948", "Invercargill",
"6473929", "Thames",
"6478991", "Whangamata",
"6439292", "Timaru",
"6439704", "Murchison",
"6439020", "Gore",
"6435887", "Invercargill",
"6436626", "Akaroa",
"6439310", "Invercargill",
"6468269", "New\ Plymouth",
"6469286", "Dannevirke",
"6462424", "Wanganui",
"6436612", "Akaroa",
"646966", "Wanganui\/New\ Plymouth",
"6434247", "Kaikoura",
"644213", "Wellington",
"6462150", "New\ Plymouth",
"644895", "Paraparaumu",
"646967", "New\ Plymouth",
"6439710", "Timaru",
"64635", "Palmerston\ North",
"6479715", "Paeroa",
"64332", "Christchurch",
"6436619", "Cheviot",
"6432665", "South\ Island",
"647210", "Hamilton",
"6468262", "Napier",
"6473994", "Rotorua",
"6439887", "Christchurch\/Blenheim\/Nelson",
"6439761", "Kurow",
"6479025", "Huntly",
"6473922", "Morrinsville",
"6497777", "Auckland",
"6432754", "Tokanui",
"6439299", "Murchison",
"6463904", "Napier",
"646382", "Taihape",
"6439285", "Invercargill",
"643462", "Dunedin\/Palmerston",
"6435994", "Ashburton",
"6472611", "Matamata",
"6469297", "Masterton",
"6436521", "Greymouth",
"64373", "Greymouth",
"6498017", "Hibiscus\ Coast",
"647551", "Tauranga",
"64377", "South\ Island",
"6472126", "Otorohanga",
"647884", "Morrinsville",
"6439050", "Geraldine",
"6468244", "Waipukurau",
"6472817", "Taupo",
"643741", "Christchurch",
"6477883", "Hamilton",
"6433993", "Te\ Anau",
"6432633", "Otautau",
"6436656", "Hokitika",
"6499046", "Pukekohe",
"6466991", "Wanganui",
"644892", "Paraparaumu",
"6462120", "Palmerston\ North",
"646321", "Marton",
"6437441", "Motueka",
"6479422", "Tauranga",
"6439083", "Cheviot",
"6499811", "Hibiscus\ Coast",
"6496100", "Pukekohe",
"649428", "Hibiscus\ Coast",
"643660", "Christchurch",
"6432724", "Greymouth",
"643465", "Palmerston",
"646385", "Ohakune",
"644818", "Wellington",
"6435681", "Invercargill",
"6472119", "Thames",
"6472629", "Taupo",
"6478996", "Huntly",
"6439069", "Haast",
"6469281", "Wairoa",
"646374", "Dannevirke",
"6439079", "Murchison",
"6436621", "Culverden",
"6462144", "Ruatoria",
"6468990", "Ruatoria",
"644219", "Wellington",
"647875", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"643236", "Winton",
"6492809", "Maungaturoto",
"643237", "Riverton\/Winton",
"6439072", "Ashburton",
"6466555", "Hawera",
"6462610", "Napier",
"643277", "South\ Island",
"6473934", "Rotorua",
"6439062", "Ashburton",
"643455", "Dunedin",
"643276", "South\ Island",
"6435697", "Westport",
"6472622", "Tauranga",
"6479101", "Rotorua",
"6432740", "Lawrence",
"6439766", "Balclutha",
"6472616", "Taumarunui",
"6462604", "Ohakune",
"646213", "Wanganui",
"6462225", "Levin",
"6469317", "Pahiatua",
"6462122", "Palmerston\ North",
"6498691", "Maungaturoto",
"6439756", "Akaroa",
"643522", "Nelson",
"6469853", "Waiouru",
"6435513", "Waitangi\ \(Chatham\ Is\.\)",
"643456", "Dunedin",
"6439052", "Mt\ Cook",
"643457", "Dunedin",
"6433955", "Mt\ Cook",
"647877", "Te\ Kuiti",
"6434237", "Culverden",
"6495533", "Whangarei",
"643235", "Invercargill",
"647876", "Te\ Kuiti",
"6499879", "Warkworth",
"6469003", "Napier\/Hastings",
"6474653", "Putaruru\/Tokoroa",
"643930", "Christchurch",
"6493208", "Helensville",
"64698", "Gisborne",
"6432226", "Timaru",
"6462803", "Palmerston\ North",
"646952", "Palmerston\ North\ W100",
"6437487", "Winton",
"643922", "Nelson",
"6493937", "Warkworth",
"6449008", "Paraparaumu",
"6494313", "Warkworth",
"6479420", "Tauranga",
"6436566", "Kurow",
"6465601", "Palmerston\ North",
"6468821", "Featherston",
"6433917", "Franz\ Josef",
"6462129", "Waiouru",
"6436576", "Cromwell",
"6496015", "Maungaturoto",
"644260", "Wellington",
"6432996", "Riverton",
"6499014", "Dargaville",
"646387", "Waiouru",
"6492831", "Maungaturoto",
"6468992", "Wairoa",
"6432447", "Timaru",
"6439321", "Amberley",
"643467", "Dunedin",
"6469247", "Wanganui",
"643466", "Dunedin",
"6434286", "Christchurch",
"6462619", "Featherston",
"647889", "Morrinsville",
"6439721", "Blenheim",
"6432811", "Fox\ Glacier",
"6432625", "Twizel",
"6433943", "Amberley",
"644245", "Wellington",
"6437773", "Dunedin",
"6432749", "Wanaka",
"6496008", "Hibiscus\ Coast",
"6439011", "Queenstown",
"6432648", "Geraldine",
"646962", "Wanganui\/New\ Plymouth",
"64937", "Auckland",
"6439274", "Queenstown",
"644250", "Wellington",
"64933", "Auckland",
"6432742", "Twizel",
"644555", "Wellington",
"6469574", "Taihape",
"6472620", "Tauranga",
"6439060", "Greymouth",
"6439070", "Motueka",
"643753", "Hokitika",
"6468999", "Napier",
"6435547", "Blenheim",
"6462626", "Mokau",
"6463921", "Palmerston\ North",
"6479845", "Paeroa",
"6437464", "Timaru",
"6499423", "Great\ Barrier\ Island",
"6435668", "Kurow",
"643415", "Balclutha",
"6499557", "Warkworth",
"6435678", "Roxburgh",
"6437474", "Oamaru",
"6474637", "Opotiki",
"6468883", "Palmerston\ North",
"6499006", "Whangarei",
"6479247", "Hamilton",
"6439769", "Roxburgh",
"6478992", "Paeroa",
"6439291", "Dunedin",
"6466527", "Taihape",
"6475828", "Hamilton",
"6436634", "Mt\ Cook",
"6434280", "Queenstown",
"647880", "Matamata",
"6436997", "Motueka",
"6435535", "Invercargill",
"6478090", "Thames",
"6436611", "Rangiora",
"6479501", "Opotiki",
"6462620", "New\ Plymouth",
"6439535", "Fairlie",
"6468261", "Masterton",
"6439076", "Ashburton",
"6439066", "Hokitika",
"6472626", "Rotorua",
"6478999", "Hamilton",
"6473921", "Matamata",
"643206", "Edendale",
"6439762", "Oamaru",
"6472612", "Te\ Awamutu",
"6472116", "Thames",
"6479853", "Putaruru",
"647552", "Tauranga",
"643590", "Christchurch",
"6479717", "Otorohanga",
"6472827", "Tauranga",
"6462104", "Marton",
"6466001", "Napier",
"643539", "Nelson",
"64338", "Christchurch",
"6432667", "South\ Island",
"6472122", "Te\ Awamutu",
"6472225", "Rotorua",
"643444", "Ranfurly",
"6434228", "Tokanui",
"6499746", "Kawakawa",
"647390", "Hamilton",
"644891", "Wellington",
"6472194", "Whakatane",
"64370", "South\ Island",
"6497775", "Helensville",
"6436652", "Winton",
"6498853", "Whangarei",
"6499042", "Hibiscus\ Coast",
"646322", "Marton",
"6496514", "Whangarei",
"6439750", "Kaikoura",
"6479027", "Paeroa",
"6439885", "Fox\ Glacier",
"646837", "Wairoa",
"643742", "Dunedin",
"6434998", "Dunedin",
"6439287", "Oamaru",
"6432990", "Lumsden",
"644393", "Paraparaumu",
"6436560", "Palmerston",
"6435885", "Invercargill",
"6469278", "Gisborne",
"6499049", "Great\ Barrier\ Island",
"6479003", "Thames",
"6467525", "Mokau",
"649459", "Whangarei",
"6436659", "Haast",
"6432731", "Timaru",
"6499458", "Kawakawa",
"6432220", "Dunedin",
"643979", "Christchurch",
"6475601", "Hamilton",
"6472129", "Whangamata",
"643939", "South\ Island",
"643654", "Timaru",
"6472803", "Waihi",
"6462161", "Masterton",
"6498880", "Helensville",
"6432714", "Cheviot",
"6434245", "Culverden",
"6462629", "Levin",
"6468996", "Napier",
"6462151", "New\ Plymouth",
"644210", "Wellington",
"6478092", "Huntly",
"6468306", "Napier\/Wairoa",
"6439711", "Geraldine",
"6434282", "Queenstown",
"6439311", "Invercargill",
"643449", "Alexandra",
"6499478", "Pukekohe",
"6496998", "Helensville",
"6499468", "Kawakawa",
"6478990", "Thames",
"647334", "Rotorua",
"6439734", "Edendale",
"6472144", "Matamata",
"6439021", "Ashburton",
"6439334", "Fox\ Glacier",
"6432615", "Amberley",
"64452", "Wellington",
"6472610", "Morrinsville",
"6435558", "Waimate",
"6439760", "Twizel",
"6432746", "Alexandra",
"6472604", "Hamilton",
"647213", "Hamilton",
"6436583", "Te\ Anau",
"6478085", "Tauranga",
"6462616", "Ruatoria",
"6432657", "Motueka",
"6434289", "Wanaka",
"6463911", "New\ Plymouth",
"6434295", "Fox\ Glacier",
"64930", "Auckland",
"6436579", "Wanaka",
"6462817", "Napier",
"643521", "Nelson",
"6434263", "Lawrence",
"6432999", "Invercargill",
"643338", "Christchurch",
"6495567", "Kaitaia",
"6436569", "Alexandra",
"6462126", "Pahiatua",
"6434273", "Lawrence",
"6439752", "Cheviot",
"6499040", "Helensville",
"6436650", "Otautau",
"6479297", "Tauranga",
"6432229", "Dunedin",
"6469017", "Marton",
"649907", "Warkworth",
"6472120", "Putaruru\/Tokoroa",
"6474443", "Matamata",
"6468251", "Wanganui",
"64379", "South\ Island",
"6478133", "Putaruru\/Tokoroa",
"6499876", "Kaikohe",
"6435507", "Ashburton",
"6498882", "Whangarei",
"6496509", "Pukekohe",
"6439457", "Winton",
"64627", "Hawera",
"647823", "Hamilton",
"6439523", "Balclutha",
"6432423", "Dunedin",
"6436683", "Rangiora",
"6432222", "Christchurch",
"643669", "Christchurch",
"6468811", "Marton",
"6462119", "Wairoa",
"6439759", "Cromwell",
"6469303", "Waipukurau",
"643417", "Milton",
"6436562", "Balclutha",
"646951", "Palmerston\ North",
"643416", "Balclutha\/Milton",
"6432608", "Dunedin",
"643921", "Blenheim",
"6437454", "Ashburton",
"6432992", "Gore",
"6439763", "Palmerston",
"6468889", "Levin",
"6432444", "Nelson",
"6499017", "Kaikohe",
"643682", "Timaru\/Waimate\/Fairlie",
"6472613", "Putaruru\/Tokoroa",
"6469040", "Wairoa",
"647812", "Hamilton",
"6436628", "Ashburton",
"6469288", "Waiouru",
"6499727", "Whangarei",
"6475625", "Rotorua",
"6436580", "Invercargill",
"6439277", "Invercargill",
"6436645", "Ranfurly",
"6469577", "Ohakune",
"646838", "Wairoa",
"6439267", "Dunedin",
"6439875", "Ranfurly",
"643243", "Tokanui\/Lumsden\/Te\ Anau",
"6439865", "Murchison",
"6499422", "Helensville",
"646762", "Stratford",
"64923", "Pukekohe",
"6479108", "Whakatane",
"6435544", "Winton",
"6466509", "Napier\/Waipukurau",
"6468882", "Napier\/Hastings",
"6478993", "Waihi",
"6469714", "Hawera",
"643335", "Christchurch",
"6436528", "Westport",
"6439520", "Dunedin",
"6432420", "Christchurch",
"6436680", "Akaroa",
"6469314", "Waiouru",
"6479859", "Tauranga",
"6463995", "Marton",
"6472802", "Paeroa",
"6466998", "New\ Plymouth",
"6434234", "Darfield",
"6469468", "Featherston",
"6469300", "Gisborne",
"6498859", "Kaitaia",
"649394", "Auckland",
"6479002", "Matamata",
"6498900", "Pukekohe",
"6432636", "Te\ Anau",
"647861", "Paeroa\/Waihi\/Thames\/Whangamata",
"6433996", "Edendale",
"6436653", "Edendale",
"6477886", "Rotorua",
"6437448", "Haast",
"6479009", "Hamilton",
"64630", "Featherston",
"6499101", "Pukekohe",
"6499043", "Hibiscus\ Coast",
"6498852", "Warkworth",
"6434270", "Oamaru",
"6499818", "Great\ Barrier\ Island",
"6434260", "Oamaru",
"6479852", "Whangamata",
"6472809", "Otorohanga",
"6433914", "Takaka",
"6478130", "Morrinsville",
"6474440", "Paeroa",
"6443", "Wellington",
"6472123", "Morrinsville",
"6437484", "Riverton",
"6435688", "Queenstown",
"6493934", "Kaitaia",
"6436582", "Riverton",
"643418", "Balclutha",
"6492838", "Pukekohe",
"6439328", "South\ Island",
"6439728", "Franz\ Josef",
"6467775", "Palmerston\ North",
"6432818", "Christchurch",
"6462623", "Stratford",
"644902", "Paraparaumu",
"6465615", "Wanganui",
"6439018", "Ranfurly",
"649399", "Auckland",
"6437776", "Cromwell",
"6432641", "Franz\ Josef",
"6468880", "Napier\/Hastings",
"6435694", "Franz\ Josef",
"6469615", "Masterton",
"6433946", "Culverden",
"6499420", "Pukekohe",
"6436595", "Mt\ Cook",
"6449741", "Paraparaumu",
"6439345", "Christchurch",
"6462607", "Taihape",
"6478093", "Rotorua",
"643337", "Christchurch",
"6439745", "Greymouth",
"6463928", "Pahiatua",
"6434283", "Cromwell",
"643336", "Christchurch",
"644571", "Wellington",
"6436589", "Otautau",
"6479000", "Hamilton",
"6462806", "Napier\/Hastings",
"6469302", "Napier",
"643941", "Christchurch",
"6468247", "Mokau",
"6472814", "Putaruru\/Tokoroa",
"6469294", "Palmerston\ North",
"6478075", "Te\ Kuiti",
"6434279", "Twizel",
"6436563", "Lawrence",
"6434269", "Twizel",
"647989", "Taupo",
"6432993", "Balclutha",
"6439855", "Rangiora",
"6472800", "Thames",
"6474656", "Te\ Awamutu",
"6498883", "Whangarei",
"6469006", "Gisborne",
"6478139", "Whangamata",
"6432422", "Tokanui\/Lumsden\/Te\ Anau",
"6436682", "Dunedin",
"6435529", "Roxburgh",
"6439522", "Dunedin",
"6479014", "Matamata",
"6499065", "Helensville",
"6474449", "Opotiki",
"6432223", "Akaroa",
"643212", "Invercargill",
"6435516", "Balclutha",
"64357", "Blenheim",
"6474442", "Morrinsville",
"6436689", "Christchurch",
"6478132", "Paeroa",
"6432429", "Timaru",
"6439529", "Palmerston",
"6432805", "Winton",
"6479850", "Tokoroa",
"6434262", "Alexandra",
"64737", "Taupo",
"647589", "Hamilton",
"6434272", "Alexandra",
"6449030", "Paraparaumu",
"647460", "Rotorua",
"6498850", "Great\ Barrier\ Island",
"6469309", "Mokau",
"6439753", "Amberley",
"6465608", "Dannevirke",
"64733", "Rotorua\/Taupo",
"6439005", "Invercargill",
"6432727", "Fox\ Glacier",
"6466008", "Ohakune",
"6479294", "Hamilton",
"6434221", "Invercargill",
"6462814", "Hawera",
"6474650", "Morrinsville",
"6469000", "New\ Plymouth",
"6495564", "Whangarei",
"64399", "South\ Island",
"6436518", "Murchison",
"6472806", "Matamata",
"646843", "Napier\/Hastings",
"6472457", "Rotorua",
"6433985", "Alexandra",
"6435561", "Dunedin",
"6439082", "Culverden",
"647980", "Hamilton",
"643278", "South\ Island",
"6434991", "Cromwell",
"643238", "Riverton\/Winton",
"6469014", "Dannevirke",
"6477889", "Whakatane",
"6433999", "Otautau",
"6432639", "Edendale",
"6462800", "Palmerston\ North",
"6433992", "Riverton",
"6432632", "Lumsden",
"6477882", "Hamilton",
"6479229", "Opotiki",
"6469850", "Napier",
"6439095", "Ashburton",
"6466549", "Ruatoria",
"6498856", "Maungaturoto",
"647862", "Paeroa",
"6435504", "Christchurch",
"6432738", "Oamaru",
"6439454", "Lumsden",
"6469271", "Pahiatua",
"6495530", "Great\ Barrier\ Island",
"6475608", "Otorohanga",
"6479856", "Tauranga",
"644203", "Wellington",
"6499451", "Warkworth",
"6437457", "Darfield",
"6479709", "Matamata",
"6432889", "Blenheim",
"6462168", "Featherston",
"64637", "Masterton",
"6435510", "Darfield",
"644817", "Wellington",
"6435671", "Oamaru",
"6472623", "Tauranga",
"644816", "Wellington",
"6477775", "Huntly",
"6473945", "Tauranga",
"649390", "Auckland",
"6435661", "Fairlie",
"6439298", "Motueka",
"649427", "Hibiscus\ Coast",
"6475821", "Hamilton",
"649426", "Hibiscus\ Coast",
"6439337", "Wanaka",
"6499717", "Whangarei",
"6475615", "Waihi",
"649552", "Pukekohe",
"6479746", "Opotiki",
"6499630", "Pukekohe",
"6492225", "Pukekohe",
"6436618", "Blenheim",
"6439073", "Motueka",
"6434405", "Alexandra",
"6439737", "Tokanui",
"6472147", "Paeroa",
"6439063", "Westport",
"6498821", "Dargaville",
"643396", "South\ Island",
"643397", "South\ Island",
"6466015", "Napier",
"643420", "Christchurch",
"6436505", "Culverden",
"6478141", "Taupo",
"6468268", "New\ Plymouth",
"649403", "Kawakawa",
"64998", "Whangarei",
"6473928", "Te\ Awamutu",
"6433940", "Westport",
"6472607", "Paeroa",
"6437770", "Nelson",
"646761", "Opunake",
"6499003", "Warkworth",
"6468886", "Wanganui",
"6432654", "Blenheim",
"64361", "Timaru",
"6473337", "Rotorua",
"6479049", "Te\ Kuiti",
"6469869", "Ruatoria",
"6473995", "Putaruru\/Tokoroa",
"6432664", "Christchurch",
"6462802", "Palmerston\ North",
"6469306", "Hawera",
"6494312", "Warkworth",
"6479714", "Huntly",
"643942", "Christchurch",
"6462107", "Dannevirke",
"6435995", "Darfield",
"6474652", "Paeroa",
"6468258", "Waiouru",
"6469002", "Hawera",
"6432426", "Blenheim",
"6439284", "Blenheim",
"6436686", "Invercargill",
"64328", "South\ Island",
"6463905", "Napier",
"6439526", "Twizel",
"6472197", "Tauranga",
"643483", "Dunedin\/Lawrence\/Mosgiel",
"6432755", "Edendale",
"646657", "Masterton",
"6435519", "Twizel",
"6496517", "Kaitaia",
"646656", "Levin",
"6435512", "Rangiora",
"6442128", "Paraparaumu",
"6439705", "Motueka",
"6474446", "Otorohanga",
"643211", "Invercargill",
"6478136", "Te\ Awamutu",
"6435526", "Kurow",
"64730", "Whakatane",
"64941", "Auckland",
"6495532", "Warkworth",
"6499873", "Kaitaia",
"6469009", "Palmerston\ North",
"6474659", "Whangamata",
"6434266", "Palmerston",
"649425", "Warkworth",
"6434276", "Palmerston",
"6468818", "Opunake",
"6462123", "Palmerston\ North",
"6432717", "Kaikoura",
"6462425", "Masterton",
"644815", "Wellington",
"6469852", "Napier",
"646388", "Taihape",
"6462809", "Napier\/Hastings",
"6432630", "Christchurch",
"643468", "Dunedin",
"6433990", "South\ Island",
"6477880", "Hamilton",
"6436586", "Edendale",
"6439718", "Mt\ Cook",
"6479244", "Tauranga",
"6462158", "Opunake",
"6436637", "Twizel",
"6462613", "Waipukurau",
"6466524", "Ohakune",
"644281", "Wellington",
"6437467", "Queenstown",
"6499461", "Whangarei",
"6439318", "Lumsden",
"6499554", "Kaitaia",
"6499471", "Hibiscus\ Coast",
"6496991", "Kaikohe",
"6437477", "Roxburgh",
"6465625", "Gisborne",
"6468805", "Wanganui",
"6436994", "Murchison",
"6439028", "Edendale",
"6432743", "Kurow",
"6437779", "Invercargill",
"6433949", "Rangiora",
"6499297", "Hibiscus\ Coast",
"6479040", "Otorohanga",
"6439045", "Twizel",
"647923", "Whakatane",
"6437772", "Timaru",
"647878", "Te\ Kuiti",
"6433942", "Akaroa",
"647464", "Hamilton",
"643458", "Dunedin\/Queenstown",
"6435551", "Franz\ Josef",
"6468993", "Taihape",
"6463918", "Wanganui",
"644572", "Wellington",
"6436596", "Queenstown",
"6436500", "Christchurch",
"6439346", "Christchurch",
"6472191", "Whakatane",
"6466010", "Taihape",
"6439746", "Dunedin",
"64938", "Auckland\/Waiheke\ Island",
"6496511", "Whangarei",
"6439042", "Oamaru",
"6432623", "Lawrence",
"6495568", "Kawakawa",
"6462818", "New\ Plymouth",
"6469616", "Featherston",
"6433945", "Cheviot",
"6437775", "Wanaka",
"644893", "Wellington",
"6479298", "Taupo",
"6447771", "Paraparaumu",
"6462101", "Levin",
"6466004", "Waipukurau",
"643234", "Riverton",
"6468809", "Masterton",
"6465622", "Stratford",
"6468802", "New\ Plymouth",
"6432711", "Akaroa",
"647879", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"6462164", "New\ Plymouth",
"643459", "Dunedin\/Queenstown",
"6477770", "Tauranga",
"6432607", "Dunedin",
"6465616", "Hawera",
"6439049", "Palmerston",
"6475604", "Hamilton",
"646376", "Pahiatua",
"6439458", "Edendale",
"6432734", "Waimate",
"6435508", "Cheviot",
"6434400", "Alexandra",
"6475610", "Putaruru\/Tokoroa",
"6467776", "Levin",
"646830", "Napier",
"6462223", "Palmerston\ North",
"64697", "Napier",
"6462416", "Waipukurau",
"6436614", "Timaru",
"643980", "Christchurch",
"6439090", "Rangiora",
"6462422", "Napier\/Hastings",
"6439006", "Nelson",
"6473999", "Taupo",
"6435515", "Oamaru",
"6432759", "South\ Island",
"6436631", "Motueka",
"6439702", "Nelson",
"6433953", "Geraldine",
"6439294", "Dunedin",
"6437461", "Fairlie",
"6499467", "Kaitaia",
"6496997", "Hibiscus\ Coast",
"6499477", "Pukekohe",
"6437471", "Kurow",
"6432806", "Edendale",
"6435999", "Christchurch",
"643221", "Invercargill",
"6474655", "Te\ Kuiti",
"6435992", "Fox\ Glacier",
"6469005", "Wanganui",
"6439856", "Darfield",
"6432658", "Murchison",
"6463902", "Gisborne",
"6499066", "Helensville",
"6473924", "Paeroa",
"6432752", "Te\ Anau",
"6439709", "Motueka",
"643905", "Ashburton",
"6462805", "Napier\/Hastings",
"6468264", "Palmerston\ North",
"647887", "Morrinsville",
"6473992", "Opotiki",
"647886", "Putaruru\/Tokoroa",
"6494315", "Warkworth",
"6478076", "Te\ Awamutu",
"6442609", "Paraparaumu",
"6496013", "Whangarei",
"643469", "Dunedin",
"6433980", "Milton",
"6435557", "Geraldine",
"647885", "Putaruru\/Tokoroa",
"643523", "Murchison",
"64362", "South\ Island",
"6473949", "Taupo",
"6434997", "Lawrence",
"6477779", "Putaruru\/Tokoroa",
"6439288", "Ashburton",
"6468254", "Ohakune",
"6439040", "Balclutha",
"6436646", "Roxburgh",
"6472828", "Tauranga",
"6479718", "Taumarunui",
"6492229", "Hibiscus\ Coast",
"6434409", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6436502", "Amberley",
"6434227", "Riverton",
"6439876", "Roxburgh",
"6442199", "Paraparaumu",
"6475619", "Hamilton",
"643410", "Balclutha\/Milton",
"6432668", "Blenheim",
"6439866", "Christchurch\/Blenheim\/Nelson",
"6436509", "Waitangi\ \(Chatham\ Is\.\)",
"6475612", "Te\ Kuiti",
"6437451", "Blenheim",
"6499457", "Kaitaia",
"6466019", "Napier",
"6434402", "Alexandra",
"6492006", "Helensville",
"6468814", "Dannevirke",
"6466553", "New\ Plymouth",
"647821", "Hamilton\/Huntly",
"6475626", "Taupo",
"6479045", "Taumarunui",
"646953", "Palmerston\ North\ W100",
"643923", "Nelson",
"6477772", "Rotorua",
"6462139", "Palmerston\ North",
"643464", "Dunedin",
"6465620", "New\ Plymouth",
"6468800", "Napier\/Hastings",
"6469277", "Gisborne",
"6439331", "Greymouth",
"6436546", "Fairlie",
"6439700", "Nelson",
"6469893", "Ruatoria",
"6472141", "Te\ Kuiti",
"6439024", "Lumsden",
"6439731", "Gore",
"6436998", "Blenheim",
"646375", "Pahiatua",
"6435677", "Ranfurly",
"6474638", "Opotiki",
"6499558", "Great\ Barrier\ Island",
"6432635", "Riverton",
"6433995", "Tokanui",
"6439314", "Winton",
"6477885", "Tauranga",
"6435667", "Waitangi\ \(Chatham\ Is\.\)",
"643279", "South\ Island",
"64790", "Taupo",
"6462420", "Palmerston\ North",
"6439092", "Rangiora",
"6475827", "Hamilton",
"6466528", "Dannevirke",
"643239", "Invercargill",
"6462154", "New\ Plymouth",
"643595", "Christchurch",
"6479248", "Rotorua\/Whakatane\/Tauranga",
"6433989", "Waimate",
"6439714", "Waimate",
"64378", "Westport",
"647874", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"6433982", "Kurow",
"646963", "Wanganui\/New\ Plymouth",
"6439085", "Waitangi\ \(Chatham\ Is\.\)",
"6439099", "Kaikoura",
"6472601", "Hamilton",
"6463914", "Stratford",
"6473990", "Te\ Awamutu",
"643454", "Dunedin",
"6473331", "Rotorua",
"6432750", "Invercargill",
"64330", "Ashburton\/Akaroa\/Chatham\ Islands",
"643752", "Franz\ Josef",
"6463900", "Gisborne",
"647211", "Hamilton",
"6435990", "Hokitika",
"6463996", "Palmerston\ North",
"6434265", "Milton",
"643230", "Invercargill",
"6462412", "Gisborne",
"643657", "Queenstown",
"6434275", "Milton",
"6478079", "Hamilton",
"6449", "Wellington",
"6469284", "Stratford",
"6462426", "Levin",
"6436624", "Darfield",
"6439002", "Rangiora",
"643270", "Christchurch",
"647988", "Rotorua",
"6496007", "Helensville",
"6474445", "Hamilton",
"6499069", "Pukekohe",
"6439706", "Nelson",
"6432448", "Dunedin",
"6472420", "Hamilton",
"6478135", "Te\ Kuiti",
"6432802", "Gore",
"6439859", "Christchurch\/Blenheim\/Nelson",
"6435996", "Akaroa",
"6463990", "Featherston",
"6432809", "Hokitika",
"6439852", "Cheviot",
"6439525", "Milton",
"6463906", "Napier",
"6462601", "Palmerston\ North",
"6436685", "Nelson",
"6432425", "Invercargill",
"6499062", "Hibiscus\ Coast",
"6432756", "Gore",
"6435548", "Westport",
"6473931", "Whangamata",
"6439009", "Greymouth",
"643446", "Roxburgh",
"6473996", "Otorohanga",
"643447", "Alexandra",
"6469305", "New\ Plymouth",
"646211", "Napier",
"6432647", "Fairlie",
"6445", "Wellington\/Hutt\ Valley",
"6478072", "Paeroa",
"643935", "South\ Island",
"6462419", "Masterton",
"6439860", "Nelson",
"6436592", "Nelson",
"6467779", "Masterton",
"643419", "Balclutha",
"6439342", "Geraldine",
"6439870", "Queenstown",
"6472132", "Taupo",
"644240", "Wellington",
"6439742", "Christchurch",
"6434238", "Waitangi\ \(Chatham\ Is\.\)",
"6466994", "Ohakune",
"6436640", "Palmerston",
"6439046", "Kurow",
"643667", "Christchurch",
"6469318", "Levin",
"6468241", "Gisborne",
"643666", "Christchurch",
"6469612", "Wanganui\/New\ Plymouth",
"6465619", "Masterton",
"6432613", "Waitangi\ \(Chatham\ Is\.\)",
"6436524", "Hokitika",
"643984", "Blenheim",
"643743", "Christchurch",
"649398", "Auckland\/Waiheke\ Island",
"6465626", "Ruatoria",
"6493938", "Auckland",
"6468806", "New\ Plymouth",
"6437488", "South\ Island",
"6435684", "Winton",
"6496", "Auckland",
"6469619", "Wanganui\/New\ Plymouth",
"6465612", "Waipukurau",
"6432721", "Motueka",
"6433918", "Fox\ Glacier",
"6475620", "Tauranga",
"6436585", "Tokanui",
"644550", "Wellington",
"6478083", "Hamilton",
"6439749", "Christchurch",
"6434293", "Haast",
"6463942", "Masterton",
"6439349", "South\ Island",
"6467772", "Hawera",
"6469045", "Waipukurau",
"6493207", "Hibiscus\ Coast",
"6436599", "Blenheim",
"6437444", "Takaka",
"643414", "Balclutha\/Milton",
"6463999", "Palmerston\ North",
"64793", "Tauranga",
"6432800", "Te\ Anau",
"6479855", "Taupo",
"6439014", "Ashburton",
"6472223", "Hamilton",
"6493943", "Helensville",
"6439000", "Christchurch",
"6497773", "Dargaville",
"6432814", "Mt\ Cook",
"6498855", "Kawakawa",
"6439883", "Hokitika",
"6439096", "Ashburton",
"6439724", "Blenheim",
"6499011", "Kaitaia",
"6439324", "Darfield",
"6492834", "Kawakawa",
"6462410", "New\ Plymouth",
"643989", "Nelson",
"64337", "Christchurch",
"6433986", "Queenstown",
"6478070", "Morrinsville",
"6463924", "Marton",
"643460", "Dunedin\/Palmerston",
"6479753", "Taupo",
"6435883", "Dunedin",
"6479005", "Tauranga",
"643751", "Fox\ Glacier",
"64757", "Tauranga",
"6439271", "Westport",
"6499060", "Warkworth",
"6469571", "Palmerston\ North",
"6436549", "Mt\ Cook",
"6498817", "Hibiscus\ Coast",
"6435698", "Hokitika",
"6472429", "Whakatane",
"6439850", "Ashburton",
"6472805", "Morrinsville",
"6463992", "Levin",
"6434243", "Akaroa",
"6479843", "Morrinsville",
"643936", "South\ Island",
"643937", "South\ Island",
"6479018", "Putaruru\/Tokoroa",
"6468885", "New\ Plymouth",
"643977", "Christchurch",
"6469610", "Wanganui",
"643445", "Cromwell",
"6436642", "Milton",
"6492009", "Pukekohe",
"6439740", "Christchurch",
"6466016", "Napier",
"6469298", "Masterton",
"6472130", "Tauranga",
"6436506", "Darfield",
"6472818", "Rotorua",
"6435533", "Murchison",
"6439872", "Alexandra",
"6439340", "Mt\ Cook",
"6439862", "Nelson",
"6436590", "Nelson",
"6498018", "Whangarei",
"6439869", "Blenheim",
"6465604", "Ohakune",
"6468824", "Wanganui",
"6439879", "Christchurch\/Blenheim\/Nelson",
"6467770", "Gisborne",
"6475616", "Whangamata",
"647822", "Hamilton\/Huntly",
"6439533", "Geraldine",
"6463940", "Levin",
"6434406", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6492226", "Helensville",
"6436649", "Gore",
"6475622", "Tauranga",
"643576", "Nelson",
"643450", "Queenstown",
"6465610", "Napier",
"6473946", "Taupo",
"6477776", "Whangamata",
"647870", "Te\ Awamutu",
"643655", "Dunedin",
"643390", "Christchurch",
"6435880", "Dunedin",
"6439027", "Winton",
"6479750", "Tauranga",
"643339", "Christchurch",
"6478073", "Putaruru\/Tokoroa",
"6436565", "Twizel",
"6499298", "Pukekohe",
"6432995", "Winton",
"6496016", "Warkworth",
"6462157", "Stratford",
"647590", "Hamilton",
"6436638", "Kurow",
"643552", "Dunedin",
"6475824", "Hamilton",
"6439853", "Amberley",
"6434240", "Ashburton",
"6439717", "Fairlie",
"6437478", "Twizel",
"6435674", "Milton",
"6439317", "Gore",
"64738", "Taupo",
"6499063", "Hibiscus\ Coast",
"6437468", "Wanaka",
"6435664", "Timaru",
"6432225", "Greymouth",
"6472220", "Tauranga",
"6444889", "Paraparaumu",
"649397", "Auckland\/Waiheke\ Island",
"649401", "Kaikohe",
"644810", "Wellington",
"6433956", "Dunedin",
"6465950", "Palmerston\ North",
"6463917", "Wanganui",
"6432651", "Queenstown",
"649396", "Auckland\/Waiheke\ Island",
"64320", "Gore",
"649420", "Helensville",
"6432803", "Otautau",
"6462413", "Gisborne",
"646763", "Opunake",
"6462226", "Napier",
"6478144", "Tauranga",
"6498824", "Kawakawa",
"6439755", "Rangiora",
"6439880", "Greymouth",
"6462115", "Wairoa",
"6497770", "Whangarei",
"6439003", "Ashburton",
"6434994", "Palmerston",
"64687", "Napier\/Hastings",
"6468257", "Taihape",
"6478082", "Tauranga",
"6467773", "Wanganui",
"643448", "Alexandra",
"6469201", "Ruatoria",
"6463943", "Masterton",
"6496518", "Kawakawa",
"6434292", "Hokitika",
"6439530", "Timaru",
"6472198", "Opotiki",
"6462625", "Hawera",
"64683", "Napier\/Hastings",
"6434224", "Te\ Anau",
"6462811", "New\ Plymouth",
"6432619", "Christchurch",
"6495561", "Whangarei",
"6462108", "Ohakune",
"6465613", "Wairoa",
"646841", "Napier\ City",
"64789", "Taumarunui",
"6479291", "Hamilton",
"6432718", "Rangiora",
"6468817", "Stratford",
"6432626", "Kurow",
"6469613", "Levin",
"6432612", "Rangiora",
"6499454", "Whangarei",
"6436593", "Nelson",
"6439451", "Invercargill",
"647987", "Tauranga",
"6435501", "Christchurch",
"6439343", "Waimate",
"6435530", "Nelson",
"6442127", "Paraparaumu",
"6434299", "Haast",
"647986", "Hamilton",
"6469274", "New\ Plymouth",
"6478095", "Taupo",
"6439743", "Christchurch",
"6472133", "Taupo",
"6434285", "Cheviot",
"6434351", "Mt\ Cook",
"643538", "Nelson",
"6499718", "Whangarei",
"6439338", "Queenstown",
"6472148", "Waihi",
"6436991", "Culverden",
"6439738", "Winton",
"6463993", "Pahiatua",
"6434242", "Darfield",
"6436617", "Cromwell",
"6499464", "Whangarei",
"6443708", "Paraparaumu",
"6499474", "Helensville",
"6496994", "Dargaville",
"6499551", "Whangarei",
"6439889", "Christchurch\/Blenheim\/Nelson",
"6479241", "Whakatane",
"6435882", "Dunedin",
"6479752", "Rotorua",
"6497779", "Great\ Barrier\ Island",
"6466521", "Palmerston\ North",
"6439297", "Takaka",
"6497772", "Kaitaia",
"6473927", "Te\ Kuiti",
"6436655", "Westport",
"6467529", "Mokau",
"6493942", "Great\ Barrier\ Island",
"6439882", "Westport",
"6499045", "Hibiscus\ Coast",
"6435889", "Timaru",
"6473338", "Rotorua",
"649458", "Dargaville",
"6472608", "Waihi",
"647921", "Rotorua",
"64329", "South\ Island",
"6434249", "Kaikoura",
"6435554", "Cromwell",
"643978", "Christchurch",
"6472125", "Huntly",
"643938", "South\ Island",
"6472222", "Hamilton",
"643334", "Christchurch",
"6479021", "Te\ Awamutu",
"6439765", "Milton",
"6472458", "Rotorua",
"6472615", "Te\ Kuiti",
"6439281", "Christchurch",
"6479849", "Thames",
"6492426", "Whangarei",
"6466007", "Stratford",
"6472821", "Hamilton",
"6434290", "Greymouth",
"6439532", "Timaru",
"6479711", "Whangamata",
"6435539", "Otautau",
"6478129", "Matamata",
"6478080", "Hamilton",
"649395", "Auckland\/Waiheke\ Island",
"6466556", "Stratford",
"6436517", "Motueka",
"6432661", "Christchurch",
"6475623", "Tauranga",
"647974", "Hamilton",
"6424", "Scott\ Base",
"6437458", "Kaikoura",
"643213", "Invercargill",
"6436643", "Balclutha",
"6475607", "Morrinsville",
"6442820", "Wellington",
"6439539", "Dunedin\/Timaru",
"6435532", "Motueka",
"6439873", "Wanaka",
"6439863", "Motueka",
"6462167", "Mokau",
"6479842", "Matamata",
"6432610", "Darfield",
"643425", "Dunedin",
"6493990", "Great\ Barrier\ Island",
"6432737", "Palmerston",
"6478995", "Matamata",
"646650", "Napier",
"6478086", "Hamilton",
"6466550", "New\ Plymouth",
"6462615", "Gisborne",
"6434231", "Christchurch",
"6434296", "Greymouth",
"647888", "Matamata",
"6468803", "Gisborne",
"6468248", "New\ Plymouth",
"6465623", "Opunake",
"646842", "Napier\/Hastings",
"6469311", "Palmerston\ North",
"6432745", "Roxburgh",
"6469711", "New\ Plymouth",
"6432629", "Roxburgh",
"6437481", "Invercargill",
"6439043", "Ashburton",
"6432622", "Balclutha",
"6493931", "Whangarei",
"6432728", "Haast",
"6433911", "Nelson",
"6468827", "New\ Plymouth",
"647863", "Waihi",
"6465607", "Taihape",
"6432616", "Ashburton",
"6474649", "Matamata",
"644202", "Wellington",
"649424", "Hibiscus\ Coast",
"6468995", "Napier",
"6468305", "Napier\/Wairoa",
"6473993", "Te\ Awamutu",
"6439017", "Cromwell",
"6496012", "Kawakawa",
"6492837", "Hibiscus\ Coast",
"64456", "Wellington",
"6432441", "Christchurch",
"6439327", "Ashburton",
"6435993", "Mt\ Cook",
"6469241", "Napier",
"6463903", "Ruatoria",
"6433959", "Balclutha",
"6432753", "Winton",
"6432817", "Christchurch",
"6466579", "Featherston",
"6439727", "Dunedin",
"6439055", "Fairlie",
"6462608", "Dannevirke",
"6433952", "Fairlie",
"643241", "Tokanui\/Lumsden\/Te\ Anau",
"6439703", "Takaka",
"643951", "Dunedin",
"64944", "Auckland",
"6495588", "Hibiscus\ Coast",
"647312", "Whakatane",
"649402", "Kawakawa",
"6463927", "Dannevirke",
"6499875", "Dargaville",
"6435541", "Te\ Anau",
"6498814", "Pukekohe",
"6443333", "Paraparaumu",
"6462222", "Ohakune",
"649431", "Maungaturoto",
"6462125", "Taihape",
"6462423", "Gisborne",
"6472625", "Opotiki",
"6479230", "Opotiki",
"64783", "Hamilton",
"6477773", "Taupo",
"6466997", "New\ Plymouth",
"643943", "Christchurch",
"6436527", "Haast",
"6469291", "Gisborne",
"647466", "Tauranga",
"6475613", "Te\ Awamutu",
"6439536", "Waimate",
"6466552", "New\ Plymouth",
"6434403", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6439075", "Takaka",
"6472811", "Tauranga",
"6439065", "Ashburton",
"6466559", "Mokau",
"6466013", "Featherston",
"6435536", "Invercargill",
"6436503", "Ashburton",
"6435687", "Lumsden",
"6492429", "Pukekohe",
"64364", "South\ Island",
"6479846", "Taumarunui",
"6437447", "Greymouth",
"6432620", "Palmerston",
"6469287", "Ohakune",
"6436627", "Waitangi\ \(Chatham\ Is\.\)",
"6434246", "Waitangi\ \(Chatham\ Is\.\)",
"6499728", "Dargaville",
"6433983", "Ranfurly",
"6496010", "Kaitaia",
"64638", "Taihape\/Ohakune\/Waiouru",
"6435886", "Invercargill",
"646590", "Palmerston\ North",
"6499018", "Maungaturoto",
"6497776", "Hibiscus\ Coast",
"6479107", "Whakatane",
"646654", "Gisborne",
"6439093", "Ashburton",
"6439886", "Christchurch\/Blenheim\/Nelson",
"647922", "Whakatane",
"6475950", "Hamilton",
"643908", "Ashburton",
"6462220", "New\ Plymouth",
"6472115", "Taumarunui",
"6469578", "Marton",
"6439268", "Dunedin",
"6439278", "Invercargill",
"649429", "Great\ Barrier\ Island",
"6433950", "Waitangi\ \(Chatham\ Is\.\)",
"6435691", "Murchison",
"647970", "Hamilton",
"643288", "Christchurch",
"6472226", "Te\ Kuiti",
"6432644", "Westport",
"644819", "Wellington",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+64|\D)//g;
      my $self = bless({ country_code => '64', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '64', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;