# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230112200227;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1534[0-24-8]\\d{5}',
                'geographic' => '1534[0-24-8]\\d{5}',
                'mobile' => '
          7(?:
            (?:
              (?:
                50|
                82
              )9|
              937
            )\\d|
            7(?:
              00[378]|
              97[7-9]
            )
          )\\d{5}
        ',
                'pager' => '
          76(?:
            464|
            652
          )\\d{5}|
          76(?:
            0[0-28]|
            2[356]|
            34|
            4[01347]|
            5[49]|
            6[0-369]|
            77|
            8[14]|
            9[139]
          )\\d{6}
        ',
                'personal_number' => '701511\\d{4}',
                'specialrate' => '(
          (?:
            8(?:
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            90(?:
              066[59]|
              1810|
              71(?:
                07|
                55
              )
            )
          )\\d{4}
        )|(
          (?:
            3(?:
              0(?:
                07(?:
                  35|
                  81
                )|
                8901
              )|
              3\\d{4}|
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '
          80(?:
            07(?:
              35|
              81
            )|
            8901
          )\\d{4}
        ',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441763", "Royston",
"441970", "Aberystwyth",
"441487", "Warboys",
"441646", "Milford\ Haven",
"441623", "Mansfield",
"441647", "Moretonhampstead",
"441758", "Pwllheli",
"442838", "Portadown",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441922", "Walsall",
"441348", "Fishguard",
"4419756", "Strathdon",
"441788", "Rugby",
"441522", "Lincoln",
"4414236", "Harrogate",
"4416866", "Newtown",
"4419646", "Patrington",
"4414379", "Haverfordwest",
"441915", "Sunderland",
"441606", "Northwich",
"441599", "Kyle",
"4416867", "Llanidloes",
"4414237", "Harrogate",
"441264", "Andover",
"441530", "Coalville",
"4419757", "Strathdon",
"441235", "Abingdon",
"441570", "Lampeter",
"441275", "Clevedon",
"441456", "Glenurquhart",
"441308", "Bridport",
"441457", "Glossop",
"4419647", "Patrington",
"441904", "York",
"441768", "Penrith",
"441628", "Maidenhead",
"441439", "Helmsley",
"441284", "Bury\ St\ Edmunds",
"441753", "Slough",
"441490", "Corwen",
"441832", "Clopton",
"441695", "Skelmersdale",
"441343", "Elgin",
"441872", "Truro",
"441544", "Kington",
"441327", "Daventry",
"441479", "Grantown\-on\-Spey",
"441326", "Falmouth",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"4418517", "Stornoway",
"441944", "West\ Heslerton",
"441254", "Blackburn",
"441467", "Inverurie",
"441841", "Newquay\ \(Padstow\)",
"441466", "Huntly",
"4418516", "Great\ Bernera",
"441303", "Folkestone",
"441732", "Sevenoaks",
"441381", "Fortrose",
"441909", "Worksop",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441772", "Preston",
"441465", "Girvan",
"441720", "Isles\ of\ Scilly",
"441289", "Berwick\-upon\-Tweed",
"441474", "Gravesend",
"441549", "Lairg",
"441325", "Darlington",
"441259", "Alloa",
"441949", "Whatton",
"441697", "Brampton",
"441883", "Caterham",
"441398", "Dulverton",
"442882", "Omagh",
"441509", "Loughborough",
"44131", "Edinburgh",
"4415079", "Alford\ \(Lincs\)",
"441277", "Brentwood",
"441858", "Market\ Harborough",
"441455", "Hinckley",
"441276", "Camberley",
"441650", "Cemmaes\ Road",
"441994", "St\ Clears",
"441236", "Coatbridge",
"441237", "Bideford",
"441917", "Sunderland",
"441863", "Ardgay",
"441916", "Tyneside",
"441400", "Honington",
"44239", "Portsmouth",
"4418905", "Ayton",
"441361", "Duns",
"4414348", "Hexham",
"441485", "Hunstanton",
"441888", "Turriff",
"441269", "Ammanford",
"441594", "Lydney",
"441440", "Haverhill",
"44286", "Northern\ Ireland",
"4415072", "Spilsby\ \(Horncastle\)",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441409", "Holsworthy",
"4418519", "Great\ Bernera",
"441297", "Axminster",
"441871", "Castlebay",
"441659", "Sanquhar",
"441296", "Aylesbury",
"441934", "Weston\-super\-Mare",
"441974", "Llanon",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441449", "Stowmarket",
"442827", "Ballymoney",
"441842", "Thetford",
"441689", "Orpington",
"442826", "Northern\ Ireland",
"441373", "Frome",
"441534", "Jersey",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441565", "Knutsford",
"441260", "Congleton",
"4418512", "Stornoway",
"4413873", "Langholm",
"4414377", "Haverfordwest",
"441955", "Wick",
"441540", "Kingussie",
"441669", "Rothbury",
"441245", "Chelmsford",
"441494", "High\ Wycombe",
"441729", "Settle",
"441280", "Buckingham",
"4419649", "Hornsea",
"4414376", "Haverfordwest",
"4414239", "Boroughbridge",
"4416869", "Newtown",
"441900", "Workington",
"441824", "Ruthin",
"4419759", "Alford\ \(Aberdeen\)",
"4412294", "Barrow\-in\-Furness",
"441792", "Swansea",
"4419752", "Alford\ \(Aberdeen\)",
"441205", "Boston",
"4413393", "Aboyne",
"4416862", "Llanidloes",
"442848", "Northern\ Ireland",
"4414232", "Harrogate",
"4419642", "Hornsea",
"441677", "Bedale",
"4413882", "Stanhope\ \(Eastgate\)",
"441985", "Warminster",
"441676", "Meriden",
"4418474", "Thurso",
"441636", "Newark\-on\-Trent",
"441555", "Lanark",
"441250", "Blairgowrie",
"441637", "Newquay",
"441664", "Melton\ Mowbray",
"441557", "Kirkcudbright",
"441556", "Castle\ Douglas",
"441635", "Newbury",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441987", "Ebbsfleet",
"441892", "Tunbridge\ Wells",
"441675", "Coleshill",
"441724", "Scunthorpe",
"441986", "Bungay",
"442893", "Ballyclare",
"441499", "Inveraray",
"441207", "Consett",
"441829", "Tarporley",
"441422", "Halifax",
"441206", "Colchester",
"4418510", "Great\ Bernera\/Stornoway",
"4415077", "Louth",
"441362", "Dereham",
"441586", "Campbeltown",
"4419467", "Gosforth",
"441246", "Chesterfield",
"441957", "Mid\ Yell",
"441223", "Cambridge",
"4415076", "Louth",
"44281", "Northern\ Ireland",
"441404", "Honiton",
"441771", "Maud",
"442898", "Belfast",
"4413394", "Ballater",
"441382", "Dundee",
"441939", "Wem",
"441566", "Launceston",
"441654", "Machynlleth",
"441567", "Killin",
"4418473", "Thurso",
"441702", "Southend\-on\-Sea",
"442825", "Ballymena",
"441579", "Liskeard",
"441684", "Malvern",
"441444", "Haywards\ Heath",
"441967", "Strontian",
"441295", "Banbury",
"4418901", "Coldstream\/Ayton",
"441590", "Lymington",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441539", "Kendal",
"4414308", "Market\ Weighton",
"4412293", "Millom",
"4419640", "Hornsea\/Patrington",
"4416860", "Newtown\/Llanidloes",
"4414230", "Harrogate\/Boroughbridge",
"441228", "Carlisle",
"441352", "Mold",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"442881", "Newtownstewart",
"441638", "Newmarket",
"4418513", "Stornoway",
"441870", "Isle\ of\ Benbecula",
"441492", "Colwyn\ Bay",
"441830", "Kirkwhelpington",
"441678", "Bala",
"441899", "Biggar",
"441337", "Ladybank",
"441376", "Braintree",
"442823", "Northern\ Ireland",
"442847", "Northern\ Ireland",
"441429", "Hartlepool",
"441377", "Driffield",
"441822", "Tavistock",
"441794", "Romsey",
"442846", "Northern\ Ireland",
"441369", "Dunoon",
"441293", "Crawley",
"441261", "Banff",
"441920", "Ware",
"44241", "Coventry",
"441633", "Newport",
"441389", "Dumbarton",
"441673", "Market\ Rasen",
"442895", "Belfast",
"441709", "Rotherham",
"4419753", "Strathdon",
"4416863", "Llanidloes",
"4414233", "Boroughbridge",
"441932", "Weybridge",
"4413392", "Aboyne",
"4419643", "Patrington",
"441972", "Glenborrodale",
"4412290", "Barrow\-in\-Furness\/Millom",
"442828", "Larne",
"441572", "Oakham",
"441844", "Thame",
"44121", "Birmingham",
"4413399", "Ballater",
"441298", "Buxton",
"441749", "Shepton\ Mallet",
"441501", "Harthill",
"4418470", "Thurso\/Tongue",
"441225", "Bath",
"441359", "Pakenham",
"441520", "Lochcarron",
"4414305", "North\ Cave",
"441226", "Barnsley",
"441953", "Wymondham",
"441227", "Canterbury",
"441809", "Tomdoun",
"441243", "Chichester",
"441583", "Carradale",
"441384", "Dudley",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"441652", "Brigg",
"441968", "Penicuik",
"441704", "Southport",
"441431", "Helmsdale",
"441442", "Hemel\ Hempstead",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441568", "Leominster",
"4418514", "Great\ Bernera",
"441744", "St\ Helens",
"442896", "Belfast",
"441983", "Isle\ of\ Wight",
"442897", "Saintfield",
"441354", "Chatteris",
"441553", "Kings\ Lynn",
"441248", "Bangor\ \(Gwynedd\)",
"4412292", "Barrow\-in\-Furness",
"4413390", "Aboyne\/Ballater",
"441588", "Bishops\ Castle",
"441722", "Salisbury",
"441770", "Isle\ of\ Arran",
"441963", "Wincanton",
"441799", "Saffron\ Walden",
"4418479", "Tongue",
"441730", "Petersfield",
"441424", "Hastings",
"442845", "Northern\ Ireland",
"4418472", "Thurso",
"441208", "Bodmin",
"4415395", "Grange\-over\-Sands",
"44117", "Bristol",
"441375", "Grays\ Thurrock",
"44113", "Leeds",
"441335", "Ashbourne",
"442880", "Carrickmore",
"441364", "Ashburton",
"441563", "Kilmarnock",
"441988", "Wigtown",
"4419644", "Patrington",
"4414234", "Boroughbridge",
"4416864", "Llanidloes",
"4419754", "Alford\ \(Aberdeen\)",
"441558", "Llandeilo",
"4412299", "Millom",
"441591", "Llanwrtyd\ Wells",
"441902", "Wolverhampton",
"4413397", "Ballater",
"441790", "Spilsby",
"441453", "Dursley",
"441779", "Peterhead",
"441865", "Oxford",
"441282", "Burnley",
"441603", "Norwich",
"441971", "Scourie",
"441834", "Narberth",
"4413396", "Ballater",
"441542", "Keith",
"441874", "Brecon",
"441931", "Shap",
"441531", "Ledbury",
"4414373", "Clynderwen\ \(Clunderwen\)",
"441942", "Wigan",
"441252", "Aldershot",
"441328", "Fakenham",
"441571", "Lochinver",
"442889", "Fivemiletown",
"441626", "Newton\ Abbot",
"441483", "Guildford",
"441395", "Budleigh\ Salterton",
"441643", "Minehead",
"441766", "Porthmadog",
"441767", "Sandy",
"441502", "Lowestoft",
"441491", "Henley\-on\-Thames",
"441458", "Glastonbury",
"441306", "Dorking",
"441855", "Ballachulish",
"441307", "Forfar",
"441463", "Inverness",
"441821", "Kinrossie",
"441608", "Chipping\ Norton",
"441786", "Stirling",
"441924", "Wakefield",
"441787", "Sudbury",
"441323", "Eastbourne",
"441347", "Easingwold",
"4415074", "Alford\ \(Lincs\)",
"441524", "Lancaster",
"442877", "Limavady",
"441346", "Fraserburgh",
"442837", "Armagh",
"441757", "Selby",
"441756", "Skipton",
"441262", "Bridlington",
"441885", "Pencombe",
"441488", "Hungerford",
"441840", "Camelford",
"4412296", "Barrow\-in\-Furness",
"441721", "Peebles",
"441992", "Lea\ Valley",
"441661", "Prudhoe",
"441887", "Aberfeldy",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441700", "Rothesay",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"441380", "Devizes",
"4412297", "Millom",
"441929", "Wareham",
"44114", "Sheffield",
"4414345", "Haltwhistle",
"4418476", "Tongue",
"441529", "Sleaford",
"441785", "Stafford",
"441350", "Dunkeld",
"441918", "Tyneside",
"441740", "Sedgefield",
"4418908", "Coldstream",
"4418477", "Tongue",
"4414301", "North\ Cave\/Market\ Weighton",
"441592", "Kirkcaldy",
"441856", "Orkney",
"441305", "Dorchester",
"441278", "Bridgwater",
"441857", "Sanday",
"441420", "Alton",
"44291", "Cardiff",
"441765", "Ripon",
"4415073", "Louth",
"441625", "Macclesfield",
"441397", "Fort\ William",
"44161", "Manchester",
"441432", "Hereford",
"441472", "Grimsby",
"441651", "Oldmeldrum",
"441879", "Scarinish",
"441698", "Motherwell",
"441913", "Durham",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441866", "Kilchrenan",
"441360", "Killearn",
"441233", "Ashford\ \(Kent\)",
"442884", "Northern\ Ireland",
"441273", "Brighton",
"441506", "Bathgate",
"4412291", "Barrow\-in\-Furness\/Millom",
"441622", "Maidstone",
"441838", "Dalmally",
"441464", "Insch",
"441435", "Heathfield",
"441670", "Morpeth",
"441475", "Greenock",
"441946", "Whitehaven",
"441630", "Market\ Drayton",
"441256", "Basingstoke",
"441947", "Whitby",
"4418903", "Coldstream",
"441878", "Lochboisdale",
"441257", "Coppull",
"441923", "Watford",
"4418471", "Thurso\/Tongue",
"441547", "Knighton",
"441324", "Falkirk",
"441546", "Lochgilphead",
"4414307", "Market\ Weighton",
"441287", "Guisborough",
"441286", "Caernarfon",
"4414306", "Market\ Weighton",
"44292", "Cardiff",
"442820", "Ballycastle",
"441454", "Chipping\ Sodbury",
"441267", "Carmarthen",
"441995", "Garstang",
"441752", "Plymouth",
"4414349", "Bellingham",
"441604", "Northampton",
"441833", "Barnard\ Castle",
"4415396", "Sedbergh",
"441928", "Runcorn",
"441873", "Abergavenny",
"441342", "East\ Grinstead",
"441782", "Stoke\-on\-Trent",
"441528", "Laggan",
"442841", "Rostrevor",
"441371", "Great\ Dunmow",
"4414342", "Bellingham",
"441919", "Durham",
"441484", "Huddersfield",
"441239", "Cardigan",
"44287", "Northern\ Ireland",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"441290", "Cumnock",
"441644", "New\ Galloway",
"4415078", "Alford\ \(Lincs\)",
"441279", "Bishops\ Stortford",
"441302", "Doncaster",
"44283", "Northern\ Ireland",
"441733", "Peterborough",
"441852", "Kilmelford",
"441773", "Ripley",
"441597", "Llandrindod\ Wells",
"442868", "Kesh",
"4413391", "Aboyne\/Ballater",
"4414378", "Haverfordwest",
"441609", "Northallerton",
"441914", "Tyneside",
"441882", "Kinloch\ Rannoch",
"441997", "Strathpeffer",
"4418904", "Coldstream",
"441560", "Moscow",
"442883", "Northern\ Ireland",
"441489", "Bishops\ Waltham",
"441234", "Bedford",
"441274", "Bradford",
"441905", "Worcester",
"441738", "Perth",
"442891", "Bangor\ \(Co\.\ Down\)",
"441778", "Bourne",
"441580", "Cranbrook",
"441862", "Tain",
"441285", "Cirencester",
"441469", "Killingholme",
"441545", "Llanarth",
"441694", "Church\ Stretton",
"441950", "Sandwick",
"441477", "Holmes\ Chapel",
"441329", "Fareham",
"441255", "Clacton\-on\-Sea",
"441550", "Llandovery",
"441945", "Wisbech",
"441476", "Grantham",
"441436", "Helensburgh",
"441980", "Amesbury",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"442888", "Northern\ Ireland",
"441392", "Exeter",
"441505", "Johnstone",
"441200", "Clitheroe",
"441959", "Westerham",
"441803", "Torquay",
"441665", "Alnwick",
"441249", "Chippenham",
"441634", "Medway",
"441725", "Rockbourne",
"441674", "Montrose",
"441460", "Chard",
"441341", "Barmouth",
"442871", "Londonderry",
"4418475", "Thurso",
"441751", "Pickering",
"441798", "Pulborough",
"442842", "Kircubbin",
"441372", "Esher",
"441827", "Tamworth",
"441209", "Redruth",
"441843", "Thanet",
"44280", "Northern\ Ireland",
"441332", "Derby",
"4414346", "Hexham",
"4412295", "Barrow\-in\-Furness",
"441497", "Hay\-on\-Wye",
"441496", "Port\ Ellen",
"441989", "Ross\-on\-Wye",
"441301", "Arrochar",
"4414347", "Hexham",
"441559", "Llandysul",
"441320", "Fort\ Augustus",
"441405", "Goole",
"441808", "Tomatin",
"441621", "Maldon",
"441761", "Temple\ Cloud",
"4414309", "Market\ Weighton",
"441600", "Monmouth",
"441536", "Kettering",
"441969", "Leyburn",
"441655", "Maybole",
"441576", "Lockerbie",
"442824", "Northern\ Ireland",
"441450", "Hawick",
"441793", "Swindon",
"441577", "Kinross",
"441685", "Merthyr\ Tydfil",
"441848", "Thornhill",
"441977", "Pontefract",
"441445", "Gairloch",
"441294", "Ardrossan",
"441569", "Stonehaven",
"441480", "Huntingdon",
"441937", "Wetherby",
"4414302", "North\ Cave",
"441388", "Bishop\ Auckland",
"4420", "London",
"442892", "Lisburn",
"441708", "Romford",
"441935", "Yeovil",
"441446", "Barry",
"441687", "Mallaig",
"442829", "Kilrea",
"4413395", "Aboyne",
"441270", "Crewe",
"441575", "Kirriemuir",
"441656", "Bridgend",
"441535", "Keighley",
"441564", "Lapworth",
"441299", "Bewdley",
"441363", "Crediton",
"4418518", "Stornoway",
"441910", "Tyneside\/Durham\/Sunderland",
"441748", "Richmond",
"441407", "Holyhead",
"441406", "Holbeach",
"441358", "Ellon",
"441639", "Neath",
"441244", "Chester",
"441690", "Betws\-y\-Coed",
"441954", "Madingley",
"441495", "Pontypool",
"441383", "Dunfermline",
"441584", "Ludlow",
"441428", "Haslemere",
"442311", "Southampton",
"441825", "Uckfield",
"441204", "Bolton",
"4419758", "Strathdon",
"4416868", "Newtown",
"4414238", "Harrogate",
"44238", "Southampton",
"441368", "Dunbar",
"4419648", "Hornsea",
"4417687", "Keswick",
"4414300", "North\ Cave\/Market\ Weighton",
"441743", "Shrewsbury",
"441984", "Watchet\ \(Williton\)",
"441727", "St\ Albans",
"441726", "St\ Austell",
"441667", "Nairn",
"441554", "Llanelli",
"441353", "Ely",
"441666", "Malmesbury",
"442870", "Coleraine",
"441340", "Craigellachie\ \(Aberlour\)",
"442899", "Northern\ Ireland",
"441493", "Great\ Yarmouth",
"441750", "Selkirk",
"442830", "Newry",
"44118", "Reading",
"441938", "Welshpool",
"442822", "Northern\ Ireland",
"441461", "Gretna",
"441823", "Taunton",
"441978", "Wrexham",
"441578", "Lauder",
"441300", "Cerne\ Abbas",
"441292", "Ayr",
"441538", "Ipstones",
"441745", "Rhyl",
"44115", "Nottingham",
"441807", "Ballindalloch",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441780", "Stamford",
"441355", "East\ Kilbride",
"441806", "Shetland",
"4414303", "North\ Cave",
"4412298", "Barrow\-in\-Furness",
"44141", "Glasgow",
"441672", "Marlborough",
"441895", "Uxbridge",
"441451", "Stow\-on\-the\-Wold",
"441620", "North\ Berwick",
"441933", "Wellingborough",
"441828", "Coupar\ Angus",
"441760", "Swaffham",
"441425", "Ringwood",
"442844", "Downpatrick",
"441796", "Pitlochry",
"441573", "Kelso",
"441797", "Rye",
"4418478", "Thurso",
"441334", "St\ Andrews",
"44116", "Leicester",
"4418906", "Ayton",
"4418907", "Ayton",
"441481", "Guernsey",
"441641", "Strathy",
"4413885", "Stanhope\ \(Eastgate\)",
"441403", "Horsham",
"441668", "Bamburgh",
"441242", "Cheltenham",
"441952", "Telford",
"4415394", "Hawkshead",
"441582", "Luton",
"441728", "Saxmundham",
"441366", "Downham\ Market",
"4419755", "Alford\ \(Aberdeen\)",
"441367", "Faringdon",
"4414235", "Harrogate",
"4416865", "Newtown",
"441653", "Malton",
"4419645", "Hornsea",
"441795", "Sittingbourne",
"441911", "Tyneside\/Durham\/Sunderland",
"441683", "Moffat",
"441202", "Bournemouth",
"441379", "Diss",
"442849", "Northern\ Ireland",
"441427", "Gainsborough",
"441443", "Pontypridd",
"441982", "Builth\ Wells",
"441271", "Barnstaple",
"441896", "Galashiels",
"441357", "Strathaven",
"441805", "Torrington",
"441663", "New\ Mills",
"441408", "Golspie",
"4418515", "Stornoway",
"441356", "Brechin",
"441723", "Scarborough",
"441747", "Shaftesbury",
"442310", "Portsmouth",
"441746", "Bridgnorth",
"442894", "Antrim",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441962", "Winchester",
"441691", "Oswestry",
"4413398", "Aboyne",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441845", "Thirsk",
"441706", "Rochdale",
"441880", "Tarbert",
"441562", "Kidderminster",
"4414304", "North\ Cave",
"441707", "Welwyn\ Garden\ City",
"441386", "Evesham",
"441387", "Dumfries",
"441224", "Aberdeen",
"441859", "Harris",
"441671", "Newton\ Stewart",
"441903", "Worthing",
"441452", "Gloucester",
"4415075", "Spilsby\ \(Horncastle\)",
"441631", "Oban",
"4418909", "Ayton",
"441754", "Skegness",
"441283", "Burton\-on\-Trent",
"441543", "Cannock",
"441344", "Bracknell",
"441527", "Redditch",
"441526", "Martin",
"441926", "Warwick",
"441253", "Blackpool",
"4417684", "Pooley\ Bridge",
"441784", "Staines",
"441943", "Guiseley",
"4418902", "Coldstream",
"441482", "Kingston\-upon\-Hull",
"441642", "Middlesbrough",
"441268", "Basildon",
"441889", "Rugeley",
"441503", "Looe",
"441304", "Dover",
"441908", "Milton\ Keynes",
"441764", "Crieff",
"441624", "Isle\ of\ Man",
"441775", "Spalding",
"441462", "Hitchin",
"442821", "Martinstown",
"441288", "Bude",
"441869", "Bicester",
"4414343", "Haltwhistle",
"441548", "Kingsbridge",
"441948", "Whitchurch",
"441291", "Chepstow",
"441877", "Callander",
"441322", "Dartford",
"441258", "Blandford",
"441876", "Lochmaddy",
"4416973", "Wigton",
"441837", "Okehampton",
"441263", "Cromer",
"442885", "Ballygawley",
"441330", "Banchory",
"441508", "Brooke",
"442840", "Banbridge",
"441769", "South\ Molton",
"441629", "Matlock",
"4417683", "Appleby",
"442886", "Cookstown",
"441993", "Witney",
"442887", "Dungannon",
"441864", "Abington\ \(Crawford\)",
"441438", "Stevenage",
"441835", "St\ Boswells",
"441875", "Tranent",
"441692", "North\ Walsham",
"4415242", "Hornby",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"4416861", "Newtown\/Llanidloes",
"4414231", "Harrogate\/Boroughbridge",
"441561", "Laurencekirk",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"4419641", "Hornsea\/Patrington",
"441776", "Stranraer",
"4418900", "Coldstream\/Ayton",
"441777", "Retford",
"441593", "Lybster",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441394", "Felixstowe",
"441737", "Redhill",
"441736", "Penzance",
"4416974", "Raughton\ Head",
"441581", "New\ Luce",
"441854", "Ullapool",
"441241", "Arbroath",
"441951", "Colonsay",
"442890", "Belfast",
"441433", "Hathersage",
"441759", "Pocklington",
"441473", "Ipswich",
"442879", "Magherafelt",
"441349", "Dingwall",
"441925", "Warrington",
"441525", "Leighton\ Buzzard",
"441789", "Stratford\-upon\-Avon",
"4414375", "Clynderwen\ \(Clunderwen\)",
"442866", "Enniskillen",
"441912", "Tyneside",
"442867", "Lisnaskea",
"441884", "Tiverton",
"4418511", "Great\ Bernera\/Stornoway",
"44247", "Coventry",
"441598", "Lynton",
"4414344", "Bellingham",
"441309", "Forres",
"44151", "Liverpool",
"441981", "Wormbridge",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0|([0-24-8]\d{5})$)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;