package Google::Ads::AdWords::v201402::CampaignChangeData;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/ch/v201402' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %campaignId_of :ATTR(:get<campaignId>);
my %campaignChangeStatus_of :ATTR(:get<campaignChangeStatus>);
my %changedAdGroups_of :ATTR(:get<changedAdGroups>);
my %addedCampaignCriteria_of :ATTR(:get<addedCampaignCriteria>);
my %deletedCampaignCriteria_of :ATTR(:get<deletedCampaignCriteria>);
my %addedAdExtensions_of :ATTR(:get<addedAdExtensions>);
my %deletedAdExtensions_of :ATTR(:get<deletedAdExtensions>);
my %changedFeeds_of :ATTR(:get<changedFeeds>);
my %deletedFeeds_of :ATTR(:get<deletedFeeds>);
my %campaignTargetingChanged_of :ATTR(:get<campaignTargetingChanged>);

__PACKAGE__->_factory(
    [ qw(        campaignId
        campaignChangeStatus
        changedAdGroups
        addedCampaignCriteria
        deletedCampaignCriteria
        addedAdExtensions
        deletedAdExtensions
        changedFeeds
        deletedFeeds
        campaignTargetingChanged

    ) ],
    {
        'campaignId' => \%campaignId_of,
        'campaignChangeStatus' => \%campaignChangeStatus_of,
        'changedAdGroups' => \%changedAdGroups_of,
        'addedCampaignCriteria' => \%addedCampaignCriteria_of,
        'deletedCampaignCriteria' => \%deletedCampaignCriteria_of,
        'addedAdExtensions' => \%addedAdExtensions_of,
        'deletedAdExtensions' => \%deletedAdExtensions_of,
        'changedFeeds' => \%changedFeeds_of,
        'deletedFeeds' => \%deletedFeeds_of,
        'campaignTargetingChanged' => \%campaignTargetingChanged_of,
    },
    {
        'campaignId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'campaignChangeStatus' => 'Google::Ads::AdWords::v201402::ChangeStatus',
        'changedAdGroups' => 'Google::Ads::AdWords::v201402::AdGroupChangeData',
        'addedCampaignCriteria' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'deletedCampaignCriteria' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'addedAdExtensions' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'deletedAdExtensions' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'changedFeeds' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'deletedFeeds' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'campaignTargetingChanged' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'campaignId' => 'campaignId',
        'campaignChangeStatus' => 'campaignChangeStatus',
        'changedAdGroups' => 'changedAdGroups',
        'addedCampaignCriteria' => 'addedCampaignCriteria',
        'deletedCampaignCriteria' => 'deletedCampaignCriteria',
        'addedAdExtensions' => 'addedAdExtensions',
        'deletedAdExtensions' => 'deletedAdExtensions',
        'changedFeeds' => 'changedFeeds',
        'deletedFeeds' => 'deletedFeeds',
        'campaignTargetingChanged' => 'campaignTargetingChanged',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201402::CampaignChangeData

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CampaignChangeData from the namespace https://adwords.google.com/api/adwords/ch/v201402.

Holds information about a changed campaign and any ad groups under that have changed. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * campaignId


=item * campaignChangeStatus


=item * changedAdGroups


=item * addedCampaignCriteria


=item * deletedCampaignCriteria


=item * addedAdExtensions


=item * deletedAdExtensions


=item * changedFeeds


=item * deletedFeeds


=item * campaignTargetingChanged




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

