# see how CODE REFs are created and then freed
use strict;
use Test;

BEGIN {plan tests=>5, todo=>[5]}

use Tcl;
my $int = new Tcl;

$int->call('after', 1000, sub {"foo, bar, fluffy\n";});

my $nok = 0;
sub foo {$nok++; print "ok $nok\n"};
$int->call('after', 1100, \&foo) for 0 .. 3;

my $q = 0;
for (1 .. 10) {
    my $r = 'aaa';
    $int->call('after', 1000, sub {"*";});
    $int->call('after', 1000, sub {$r++;"$r#";});

    $int->call('if', 1000, sub {
	$r++;
	$q++;
    });
}

$int->call('after', 3000, 'set var fafafa');
$int->icall('vwait', 'var'); # will wait for 3 seconds

# we have a number of commands created in Tcl, '::perl' package,
# but they must have been disposed.
my @perl = $int->icall('info', 'commands', '::perl::*');
#print STDERR "[[@perl; $r]]\n";

$nok++;
print +($#perl>10?"not ":""), "ok $nok\n";

