use strict;
use Digest::SHA3;

my $TAGS = join('|', qw(Len Msg MD));
my @vecs = ();
while (<DATA>) {
	next unless /^\s*($TAGS)\s*=\s*([\dA-F]+)/o;
	push(@vecs, $2);
}

my $numtests = scalar(@vecs) / 3;
print "1..$numtests\n";

for (1 .. $numtests) {
	my $sha3 = Digest::SHA3->new(512);
	my $Len = shift @vecs;
	my $Msg = pack("H*", shift @vecs);
	my $MD = shift @vecs;
	my $computed = $sha3->add_bits($Msg, $Len)->hexdigest;
	print "not " unless $computed eq lc($MD);
	print "ok ", $_, "\n";
}

__DATA__
# ShortMsgKAT_512.txt
# Algorithm Name: Keccak
# Principal Submitter: The Keccak Team (Guido Bertoni, Joan Daemen, Michaël Peeters and Gilles Van Assche)

Len = 0
Msg = 00
MD = 0EAB42DE4C3CEB9235FC91ACFFE746B29C29A8C366B7C60E4E67C466F36A4304C00FA9CAF9D87976BA469BCBE06713B435F091EF2769FB160CDAB33D3670680E

Len = 1
Msg = 00
MD = 7D9025BB145A0814083E934BAA80EDE67322651DE52062BF9EB93623C37EFC74C62240CF8539107F9210C1E1126F79CBAEDA6B82B4A8CE6821589C403FA76B9A

Len = 2
Msg = C0
MD = 0AE7DAC687C3525D5C2A6C4119EA3968D43DFE69C2407A44D3DE6B804D784530462440E4881FD42785E1CB69AF4F036D96D8FF1EE35D9B3FA4A2859F592FB2DC

Len = 3
Msg = C0
MD = 5A844DE7D6B8BE77BEC55021C9BFA375C4B97D79633C7EA4E7E2BC4C64AC6349D3A0142AAA50C2118B1D94AF9A5B804AF94F259B2D06C3F4A4997AFB8F787F6B

Len = 4
Msg = 80
MD = B9F236B9C7CA24FE356E9375B34831B0054D4AB5CFB9E326C9E411C1805B3ADB36E7D6CECCAC123F27638FAD3F34C48F8813A338CD53824D19BC14F6EAC218B6

Len = 5
Msg = 48
MD = 88CD5E4AB2B5CC16CF48E87B1EE3EE1FC5B1EA98142E02346429E5C8F18B570120A04040CDAB16643BFD70D31AB3FD6FC360955AB4F6A9494F4FDFAA9B6576B2

Len = 6
Msg = 50
MD = 5C69CFB002435D627390C62F2E7E74A688E537EA1DAC71D97F6D99BCCB64FDA7D45A8E6B9DAC199B78C4A3B59B04C8F1354B8D15B01DB520932F1544DFBF757B

Len = 7
Msg = 98
MD = 90E09885B5F8B9192E8380522F96D6C1C6D407AA9B73CB07AD8B84C310F08ADAD507B63C2C041F00119062D63421FFB51E81D39DB17A022730A03D6FEECBCF0B

Len = 8
Msg = CC
MD = 8630C13CBD066EA74BBE7FE468FEC1DEE10EDC1254FB4C1B7C5FD69B646E44160B8CE01D05A0908CA790DFB080F4B513BC3B6225ECE7A810371441A5AC666EB9

Len = 34241
Msg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
MD = 67CAB6BECB4E5AB5D010577EF22AA77C65A8F37949A59CA2B2F9E1A9BF195C61C92999EC4421D60D3828EF8BE89AB916052912E70F201F9B21FE1FDB007D6860
