package WebService::Bonusly::Bonuses;
$WebService::Bonusly::Bonuses::VERSION = '0.151580';
use v5.14;
use Moose;
use Carp;
use JSON;
use URI::Escape;

has ws => (
    is          => 'ro',
    isa         => 'WebService::Bonusly',
    required    => 1,
    weak_ref    => 1,
    handles     => [ qw( token base_url ua ) ],
);


sub get {
    my ($self, %params) = @_;

    my %clean;
            
    croak "parameter id is required for bonuses->get"
        unless defined $params{id};
    
    $clean{id} = $params{id}
        if defined $params{id};
    
    my $path = $self->base_url . "bonuses/:id";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
    $path .= '?';
    $path .= 'access_token=' . $self->token;    while (my ($k, $v) = each %clean) {
        $path .= uri_escape($k) . '=' . uri_escape($v);
    }

    my $res = $self->ua->get($path);
    
    return decode_json($res->content);
}

sub give {
    my ($self, %params) = @_;

    my %clean;
            
    croak "parameter receiver_email is required for bonuses->give"
        unless defined $params{receiver_email};
    
    $clean{receiver_email} = $params{receiver_email}
        if defined $params{receiver_email};
            
    croak "parameter reason is required for bonuses->give"
        unless defined $params{reason};
    
    $clean{reason} = $params{reason}
        if defined $params{reason};
            
    croak "parameter amount is required for bonuses->give"
        unless defined $params{amount};
    
    $clean{amount} = $params{amount}
        if defined $params{amount};
            
    $clean{giver_email} = $params{giver_email}
        if defined $params{giver_email};
    
    my $path = $self->base_url . "bonuses";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
    $path .= '?access_token=' . $self->token;    my $content = encode_json(\%clean);
    my $res = $self->ua->post($path, [ 'Content-Type' => 'application/json' ], $content); 
    
    return decode_json($res->content);
}

sub list {
    my ($self, %params) = @_;

    my %clean;
            
    $clean{limit} = $params{limit}
        if defined $params{limit};
            
    $clean{start_time} = $params{start_time}
        if defined $params{start_time};
            
    $clean{end_time} = $params{end_time}
        if defined $params{end_time};
            
    $clean{non_zero} = $params{non_zero}
        if defined $params{non_zero};
            
    $clean{top_level} = $params{top_level}
        if defined $params{top_level};
            
    $clean{giver_email} = $params{giver_email}
        if defined $params{giver_email};
            
    $clean{receiver_email} = $params{receiver_email}
        if defined $params{receiver_email};
            
    $clean{user_email} = $params{user_email}
        if defined $params{user_email};
            
    $clean{hashtag} = $params{hashtag}
        if defined $params{hashtag};
    
    my $path = $self->base_url . "bonuses";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
    $path .= '?';
    $path .= 'access_token=' . $self->token;    while (my ($k, $v) = each %clean) {
        $path .= uri_escape($k) . '=' . uri_escape($v);
    }

    my $res = $self->ua->get($path);
    
    return decode_json($res->content);
}


__PACKAGE__->meta->make_immutable;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Bonusly::Bonuses

=head1 VERSION

version 0.151580

=for Pod::Coverage *EVERYTHING*

=head1 AUTHOR

Andrew Sterling Hanenkamp <hanenkamp@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Qubling Software LLC.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
