use strict;
use warnings;
use File::Spec;

use Test::More tests => 12;
use Math::ThinPlateSpline;
pass();

SCOPE: {
  my $tps = Math::ThinPlateSpline->new_from_string(<<'HERE');
  0.0000000000000000
  4
  1.0000000000000000 2.0000000000000000 3.0000000000000000 4.0000000000000000 3.0000000000000000 2.0000000000000000 6.0000000000000000 8.0000000000000000 7.0000000000000000 0.0000000000000000 2.0000000000000000 1.0000000000000000
  7 7
  76.1282302345421726 48.8257879018343246 0.0000000000000000 153.9599631075726904 1.0000000000000000 6.0000000000000000 7.0000000000000000 0.0528528636519009 21.5017291389071197 153.9599631075726904 -8.1372249379762316 0.9471471363480991 -0.3171171819114054 0.6300299544366936 0.1512307041684772 -0.3434123013211033 101.6975331439180366 -1.9955849272494781 1.1740312736145164 2.9837138337604783 1.1577451073749945 0.0000000000000000 0.5354418610286216 -0.0620307960346208 8.2568181154533047 0.5656838691176924 1.3548799582944675 2.7344714393082974 0.0394071948179716 0.0035305376382074 0.0634866781511289 -0.5948669759651798 0.2192201735352306 0.3812236889660673 1.2750706567583809 0.0131357316059905 0.1562031375696697 -0.1774775526951202 -0.1338879215519750 0.5611680106476381 0.4677340607338854 -0.3343051749222107 0.0131357316059905 0.0166794750484292 -0.0154179881717575 -0.1111106003679424 0.2373003594202941 0.0696011537289757 -0.0600865257276508
  7 1
  -0.0765202079916962 -0.0255067359972321 0.0297578586634374 0.0722690853254909 -2.1222784860695558 0.4710195262116080 0.4629071588178782
  4 4
  0.0000000000000000 11.5129258654697679 76.1282302345421726 4.0235949726467775 11.5129258654697679 0.0000000000000000 48.8257879018343246 24.0823118495794013 76.1282302345421726 48.8257879018343246 0.0000000000000000 153.9599631075726904 4.0235949726467775 24.0823118495794013 153.9599631075726904 0.0000000000000000
HERE

  isa_ok($tps, 'Math::ThinPlateSpline');
}

SCOPE: {
  my $tps;
  eval { $tps = Math::ThinPlateSpline->new_from_string("blah"); };
  ok($@ && !defined($tps), "new_from_string(bollocks) fails gracefully" . ($@?"(Error: $@)":""));
}

pass(); # still alive

SCOPE: {
  my $testdata = [ [1., 2., 3.], [1, 1, 1], [0, 0, 0.], [4, 5, 6] ];
  my $res = Math::ThinPlateSpline::typemap_test_function($testdata);
  $testdata->[2] = [0,0,0];
  is_deeply($res, $testdata);
}

pass(); # still alive

SCOPE: {
  my $testdata = [ [1., 2., 3.], [3, 1, 1], [0, 0, 2.], [4, 9, 6] ];
  my $tps = Math::ThinPlateSpline->new($testdata, 0);
  my $z = $tps->evaluate(3, 1);
  is($z, 1);
}

pass(); # still alive

SCOPE: {
  my $testdata = [ [1., 2., 3.], [3, 1, 1], [0, 0, 2.], [4, 9, 6] ];
  my $tps = Math::ThinPlateSpline->new($testdata, 10.);
  my $z = $tps->evaluate(3, 1);
  ok(defined $z);
}

pass(); # still alive

SCOPE: {
  my $testdata = [ [1., 2., 3.], [3, 1, 1], [0, 0, 2.], [4, 9, 6] ];
  my $tps = Math::ThinPlateSpline->new($testdata, 200.);
  my $e = $tps->get_bending_energy();
  ok(defined($e) && $e > 0);
}

pass(); # still alive


# leak test:
#for (1..100000000) {
#  SCOPE: {
#    my $testdata = [ [1., 2., 3.], [3, 1, 1], [0, 0, 2.], [4, 9, 6] ];
#    my $tps = Math::ThinPlateSpline->new($testdata, 10.);
#  }
#}

