use utf8;

package SemanticWeb::Schema::PlayGameAction;

# ABSTRACT: The act of playing a video game.

use Moo;

extends qw/ SemanticWeb::Schema::ConsumeAction /;


use MooX::JSON_LD 'PlayGameAction';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v15.0.0';


has game_availability_type => (
    is        => 'rw',
    predicate => '_has_game_availability_type',
    json_ld   => 'gameAvailabilityType',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::PlayGameAction - The act of playing a video game.

=head1 VERSION

version v15.0.0

=head1 DESCRIPTION

The act of playing a video game.

=head1 ATTRIBUTES

=head2 C<game_availability_type>

C<gameAvailabilityType>

Indicates the availability type of the game content associated with this
action, such as whether it is a full version or a demo.

A game_availability_type should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::GameAvailabilityEnumeration']>

=item C<Str>

=back

=head2 C<_has_game_availability_type>

A predicate for the L</game_availability_type> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::ConsumeAction>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2022 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
