use utf8;

package SemanticWeb::Schema;

# ABSTRACT: Moo classes for http://schema.org/ classes

use v5.10.1;

use Moo;

use List::Util qw/ first /;
use MooX::JSON_LD 'base';
use Ref::Util qw/ is_blessed_ref is_plain_arrayref /;
use Types::Standard qw/ Str /;

use namespace::autoclean;

our $VERSION = 'v15.0.0';

# RECOMMEND PREREQ: aliased
# RECOMMEND PREREQ: Class::XSAccessor 1.18
# RECOMMEND PREREQ: Ref::Util::XS
# RECOMMEND PREREQ: Type::Tiny::XS


has id => (
    is        => 'rw',
    isa       => Str,
    predicate => 1,
    json_ld   => '@id',
);


around _build_context => sub { return 'http://schema.org/' };


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema - Moo classes for http://schema.org/ classes

=head1 VERSION

version v15.0.0

The version number of this distribution is based on the corresponding
version of schema classes.

=head1 SYNOPSIS

  use aliased 'SemanticWeb::Schema::Person' => 'Person';

  my $person = Person->new(
    name        => 'James Clerk Maxwell',
    birth_date  => '1831-06-13',
    birth_place => 'Edinburgh',
  );

  print $person->json_ld;

=head1 DESCRIPTION

This distribution contains Perl classes for L<https://schema.org>
semantic markup. These can be used to generate JSON-LD
to embed in websites.

This is a base class for the C<SemanticWeb::Schema> classes, which
were generated automatically from the following sources:

=over

=item L<https://schema.org/version/15.0/schemaorg-all-http.rdf>

=back

=head1 ATTRIBUTES

=head2 C<id>

If this is set, it adds a C<@id> to the L</json_ld_data>.

=head2 C<context>

The context defaults to "http://schema.org/".

=head1 FREQUENTLY ASKED QUESTIONS

=head2 How are these classes generated?

A script in the F<devel> directory downloads the RDF descriptions of the data, and uses that to generate the classes.

The author may make some manual changes to work around any bugs in the class generation.

=head2 Why don't you split this into separate distributions?

As of v14, there are more than 890 classes. It would be difficult to rebuild and upload separate distributions for each
class. Each distribution would have separate permissions and nearly duplicate metadata files on CPAN, and would end up
using more disk space and network bandwidth.  It would add the risk of breaking something for users if there was a
missing or inconsistent dependency, and increase the time it would take to install if users want multiple classes.

The benefit of saving disk space is rather small considering the potential problems.

=head1 SEE ALSO

=over

=item L<Moo>

=item L<MooX::JSON_LD>

=item L<http://schema.org/>

=back

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 CONTRIBUTORS

=for stopwords Mathias Reitinger Arikawa Takaya Mohammad S Anwar

=over 4

=item *

Mathias Reitinger <reitinger@cpan.org>

=item *

Arikawa Takaya <tky.c10.ver@gmail.com>

=item *

Mohammad S Anwar <mohammad.anwar@yahoo.com>

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2022 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
