use utf8;

package SemanticWeb::Schema::VideoObjectSnapshot;

# ABSTRACT: A specific and exact (byte-for-byte) version of a [[VideoObject]]

use Moo;

extends qw/ SemanticWeb::Schema::VideoObject /;


use MooX::JSON_LD 'VideoObjectSnapshot';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v15.0.0';




1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::VideoObjectSnapshot - A specific and exact (byte-for-byte) version of a [[VideoObject]]

=head1 VERSION

version v15.0.0

=head1 DESCRIPTION

A specific and exact (byte-for-byte) version of a L<SemanticWeb::Schema::VideoObject>. Two byte-for-byte identical files, for the purposes of this type, considered identical. If they have different embedded metadata the files will differ. Different external facts about the files, e.g. creator or dateCreated that aren't represented in their actual content, do not affect this notion of identity.

=head1 SEE ALSO

L<SemanticWeb::Schema::VideoObject>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2022 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
