# Generated by default/object.tt
package Paws::Lightsail::ContainerServiceDeploymentRequest;
  use Moose;
  has Containers => (is => 'ro', isa => 'Paws::Lightsail::ContainerMap', request_name => 'containers', traits => ['NameInRequest']);
  has PublicEndpoint => (is => 'ro', isa => 'Paws::Lightsail::EndpointRequest', request_name => 'publicEndpoint', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::ContainerServiceDeploymentRequest

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::ContainerServiceDeploymentRequest object:

  $service_obj->Method(Att1 => { Containers => $value, ..., PublicEndpoint => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::ContainerServiceDeploymentRequest object:

  $result = $service_obj->Method(...);
  $result->Att1->Containers

=head1 DESCRIPTION

Describes a container deployment configuration of an Amazon Lightsail
container service.

A deployment specifies the settings, such as the ports and launch
command, of containers that are deployed to your container service.

=head1 ATTRIBUTES


=head2 Containers => L<Paws::Lightsail::ContainerMap>

An object that describes the configuration for the containers of the
deployment.


=head2 PublicEndpoint => L<Paws::Lightsail::EndpointRequest>

An object that describes the endpoint of the deployment.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

