#!perl -T
use 5.006;
use strict;
use warnings;
use Test::More 'no_plan';
use MIME::Base64;
use Imager;
use Imager::Filter::Autocrop 'autocrop_test';

my %detect = ();
my $img = Imager->new();
my %types = $img->can('read_types') ? map {$_, 1} Imager->read_types : %Imager::formats;
my $images = load();

foreach my $type (keys %{$images}) {
    if ($types{$type}) {
         my $rt = 0;
         foreach my $i (@{$images->{$type}}) {
             $img->read(data => $i->[0], type => $type) or die $img->errstr;
             %detect = ();
             $img->filter(type => 'autocrop_test', detect => \%detect) or die $img->errstr;
             my $l = join ".", map { $detect{$_} } sort keys %detect;
             ++$rt;
             ok($l eq $i->[1], "Checking image crop parameters - $type: $rt [$i->[1] != $l]");
         }
    }
}

diag( "Testing Imager::Filter::Autocrop $Imager::Filter::Autocrop::VERSION, Perl $], $^X" );

sub load {
    my $images = {
        gif => [ 
            [ qq~R0lGODlhUAAyAOcqAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEhISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdHR0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpaWltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1tbW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CAgIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOTk5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaampqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zMzM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/v///yH5BAEKAPsALAAAAABQADIAAAj+AP8JHEiwoMGDCBMqXMiwocOHECNKnEixosWLGDNq3Mixo8ePIEOKHEmypMmTKFOqXMmypcuXMGMmfAKAiUF/RQBckRlxXAMArApSAoChHc+IkABsiDdwmwIAs45G5EcDABuB/HIAECNVorMBApT9OwTgA9OuEeUAgOHMQIBeaCXS+wDg59W4EmcBAFCiHl6JyQQAUPI3or0Te4EWfugGQItHSuUtZvgrQIFn/XAAaDNZoTy6gwRGIyBgWWeEYgDU4DfQDgAZrE8TpAUAwTWC9UAAeCR7IDsMABwZtAWAwbje/6wA8OHv4BUAT5BLn069uvXr2LNr3869u/fv4MMFix8PMyAAOw==~, '32.33.47.15' ],
            [ qq~R0lGODlhUAAyAOcqAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEhMTExQUFBUVFRYWFhcXFxgYGBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICEhISIiIiMjIyQkJCUlJSYmJicnJygoKCkpKSoqKisrKywsLC0tLS4uLi8vLzAwMDExMTIyMjMzMzQ0NDU1NTY2Njc3Nzg4ODk5OTo6Ojs7Ozw8PD09PT4+Pj8/P0BAQEFBQUJCQkNDQ0REREVFRUZGRkdHR0hISElJSUpKSktLS0xMTE1NTU5OTk9PT1BQUFFRUVJSUlNTU1RUVFVVVVZWVldXV1hYWFlZWVpaWltbW1xcXF1dXV5eXl9fX2BgYGFhYWJiYmNjY2RkZGVlZWZmZmdnZ2hoaGlpaWpqamtra2xsbG1tbW5ubm9vb3BwcHFxcXJycnNzc3R0dHV1dXZ2dnd3d3h4eHl5eXp6ent7e3x8fH19fX5+fn9/f4CAgIGBgYKCgoODg4SEhIWFhYaGhoeHh4iIiImJiYqKiouLi4yMjI2NjY6Ojo+Pj5CQkJGRkZKSkpOTk5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnZ6enp+fn6CgoKGhoaKioqOjo6SkpKWlpaampqenp6ioqKmpqaqqqqurq6ysrK2tra6urq+vr7CwsLGxsbKysrOzs7S0tLW1tba2tre3t7i4uLm5ubq6uru7u7y8vL29vb6+vr+/v8DAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8jIyMnJycrKysvLy8zMzM3Nzc7Ozs/Pz9DQ0NHR0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3t/f3+Dg4OHh4eLi4uPj4+Tk5OXl5ebm5ufn5+jo6Onp6erq6uvr6+zs7O3t7e7u7u/v7/Dw8PHx8fLy8vPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/v///yH5BAEKAP8ALAAAAABQADIAAAifAP8JHEiwoMGDCBMqXMiwocOHECNKnEixosWLGDNq3Mixo8ePIEOKHEmypMmTKFOqXMmypcuXMGPKnEmzps2bDwHoPKgTAE6GOw0G/blwqECjRBP2HLg0KVCfR6E6LboT6VSlPaVepap1q8KmXr+CDcuzaleyTKGORfvPqNWwY9fCPfv2at26SeVGPcu2r9+/gAMLHky4sOHDiBMrrhgQADs=~, '36.34.48.19' ],
            [ qq~R0lGODlhUAAyAMZEAAAAAAEBAQICAgMDAwQEBAUFBQYGBggICAoKCgwMDA0NDRgYGBsbGx8fHyAgICUlJScnJy0tLTAwMDIyMjQ0NDU1NTg4ODk5OT4+PkVFRUpKSkxMTE9PT1ZWVldXV2JiYmxsbG1tbW5ubnJycnZ2doODg4eHh46Ojo+Pj5CQkJSUlKysrLOzs7S0tLa2tr29vb+/v8nJycrKysvLy87Ozs/Pz9HR0dfX19vb2+Pj4+zs7O3t7fHx8fLy8vT09PX19fb29vz8/P39/f7+/v///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////yH5BAEKAH8ALAAAAABQADIAAAfxgESCg4SFhoeIiYqLjI2Oj5CRkpOUlZaXmJmam5ydnp+goaKjpKWmp6ipqqusra6vsLGys7S1qRwAG4ZDGQAeto05CgArhSoACzvAjSkADDyDOAgALMuNQRQAIIJBFwAf1o40AwIyRCYADdDhjSMAEjQGAS/sjj4NAMPb9Y4sAAAPfvBzFEMAAA0DGwGB8I9YwkUiAERA4azHQ0QwAhSoIcQCgBAXDfXAV0KQDQICZoQk9AFAhSCDSACYAHNlCwAHbhD64QAAipU6FgA4YcgFgAQ5QnYAgGHIIQ8AOKycSrWq1atYs2rdyrWr169gw64KBAA7~, '35.31.45.18' ],
            [ qq~R0lGODlhUAAyAIABAAAAAP///yH5BAEKAAEALAAAAABQADIAAAJxjI+py+0Po5y02ouz3rz7D4biSJbmiabqyrbuC8fyTNf2jef6HgH+4gPwID9Fcfg4GpTIRvDwbBKFS6o0+WNenUHrFuv9OqLiMbkMzIbRUOqZHVBqy+c3fT3f5vNNe3UNFyg4SFhoeIiYqLjI2Oi4UQAAOw==~, '36.32.46.19' ],
        ],
        jpeg => [
            [ qq~/9j/4AAQSkZJRgABAQEASABIAAD/2wBDAAMCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwYIDAoMDAsKCwsNDhIQDQ4RDgsLEBYQERMUFRUVDA8XGBYUGBIUFRT/wgALCAAyAFABAREA/8QAFwABAQEBAAAAAAAAAAAAAAAAAAcECP/aAAgBAQAAAAHqkABibQEozWABG1kAAAAAH//EABwQAAEEAwEAAAAAAAAAAAAAAAQCAwUGASYwUP/aAAgBAQABBQLsk0dZT5o4znC7BOg5qbS7LI8JtebjOxOm2Twv/8QAKxAAAgEBBAcJAAAAAAAAAAAAAQMCBAAFEUIGEhUwQVHRIiQzQ1BTYXHB/9oACAEBAAY/At9Omi9cqmA1pJExrgc8LKW561McdVcZzAMz8c9yjSKiHe7v8WPvIzR/bT0mq44QliqgSfLXxl9nc7DSTs2kIZeDI5zlV1tK6Zdm6rwJbRHgtmZfT0P/xAAgEAEAAQIHAQEAAAAAAAAAAAABESFxADAxQWGB0VBR/9oACAEBAAE/Ic4ksVBWinIVK44HOXIK1WyQaQNeBNS1R3vGFkGqeNReeep2jJKzU5SWRbk2fpjeoQ8SOvpfh//aAAgBAQAAABD/AP8A/wC//wD/AP8A/wD/AP/EABwQAQEBAAIDAQAAAAAAAAAAAAERITAxAEFQUf/aAAgBAQABPxDmjakkNCqYIBp++LsgEPKUdDAunDZ3qNhX9UqXpoHwVqHogWigQqaQqo4BlmiAIB7cBz2Iuj9P7v3coC60C/DH/9k=~, '32.32.48.8' ],
            [ qq~/9j/4AAQSkZJRgABAQEASABIAAD/2wBDAAMCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwYIDAoMDAsKCwsNDhIQDQ4RDgsLEBYQERMUFRUVDA8XGBYUGBIUFRT/wgALCAAyAFABAREA/8QAGQABAQEAAwAAAAAAAAAAAAAAAAYHAQII/9oACAEBAAAAAfVIAAAIHpoICKzbfgEZzZAAAA//xAAdEAACAQQDAAAAAAAAAAAAAAAEBgUDFTBAAQIH/9oACAEBAAEFAthlniV0mXYa/WZwOR4gC75nQ5hicBa5cGGcXbqZsf/EACcQAAEDAgQFBQAAAAAAAAAAAAECAwQFEhETITEAIzBAQRQyUVJi/9oACAEBAAY/Au4gyFobVSFrypK8De0T7Vb7cQqTTEtPS3ea8twEpZZ+dDufHRlma3ntupykseXVHZI4nUyoNlus2odvWq7MawAAB/O3RjVGTIzWIqeRFs0Sv7k46niBNYkejnQ14pesuuT5QRiND3P/xAAhEAABAwMEAwAAAAAAAAAAAAABESExAFFhMEBBsXGB0f/aAAgBAQABPyHcWQqjIqx8t3TXskMkwDAXsaKuCBLXmK6iEXij6wWoYZEg+aLixRj59AMEaoFhyJb0eRnvuf/aAAgBAQAAABD/AP8A/wB/z/f/AP8A/wD/xAAbEAEBAQEAAwEAAAAAAAAAAAABESExMEBBAP/aAAgBAQABPxD2DcxXTcHrAWyEVATLbmnFiohALLieH4bXODBFvgKEPxWyDRWV1RAoLBTHg4fy8xrqQQSlGivyIHI0IQGXVR17P//Z~, '40.32.48.16' ],
            [ qq~/9j/4AAQSkZJRgABAQEASABIAAD/2wBDAAMCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwYIDAoMDAsKCwsNDhIQDQ4RDgsLEBYQERMUFRUVDA8XGBYUGBIUFRT/2wBDAQMEBAUEBQkFBQkUDQsNFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBT/wgARCAAyAFADAREAAhEBAxEB/8QAGgABAAIDAQAAAAAAAAAAAAAAAAUHAgYIA//EABQBAQAAAAAAAAAAAAAAAAAAAAD/2gAMAwEAAhADEAAAAeqQAAAAAAAAAAAVUSJYgAAAOdi3zagAADzIAxNlAAAAAAAAAAAB/8QAHBABAAMAAgMAAAAAAAAAAAAABQMEBgJAEiAw/9oACAEBAAEFAuwfoZyWsmgg58d1Wl2yWYZhdF95OPnwCBrZ6lQArmJ9j//EABQRAQAAAAAAAAAAAAAAAAAAAGD/2gAIAQMBAT8BDf/EABQRAQAAAAAAAAAAAAAAAAAAAGD/2gAIAQIBAT8BDf/EACYQAAICAAUDBAMAAAAAAAAAAAECAwQABRESMSFBUhMUMEBTcfD/2gAIAQEABj8C+xmGWZ1ZBCqbVW0yhd8XcdO64s5nYYxUJzpTqlRqE8yeevwnLMuijkOWKZpp28yOkQ/f9xivZhT0umx4fxMOV+BlDFCRpuXkY9tW3vucyPLKdXkY9ycXbtd5ENwhpIdR6e7yA05+z//EACAQAAIBAwUBAQAAAAAAAAAAAAERIQAxQTBAUWFxgZH/2gAIAQEAAT8h3AETIsIZ0AgOGZNRStTB4Ur01+jRHGZFi43KT5QeJU4VmnCx0tApR0CvUMEP0UYkQUnTIwDPzFWjEDHuAWZnc//aAAwDAQACAAMAAAAQkkkkkkkkkkkkkkkkkAkkkkgkkkkkkkkkkkk//8QAFBEBAAAAAAAAAAAAAAAAAAAAYP/aAAgBAwEBPxAN/8QAFBEBAAAAAAAAAAAAAAAAAAAAYP/aAAgBAgEBPxAN/8QAGxABAQEAAgMAAAAAAAAAAAAAAREhADAxQEH/2gAIAQEAAT8Q9hk2Tigb+xICUCkVqlRhs2IchUEQ6FeVKVgKn1bgioofJE+MQ7MMwhpwvQHoIEiIZw8lCmiZwtNAIEoPhQYOX8Sekj9D7ylUoJ7H/9k=~, '40.24.48.16' ],
            [ qq~/9j/4AAQSkZJRgABAQEASABIAAD/2wBDAAMCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwYIDAoMDAsKCwsNDhIQDQ4RDgsLEBYQERMUFRUVDA8XGBYUGBIUFRT/2wBDAQMEBAUEBQkFBQkUDQsNFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBT/wgARCAAyAFADAREAAhEBAxEB/8QAGAABAQEBAQAAAAAAAAAAAAAAAAYHAQj/xAAUAQEAAAAAAAAAAAAAAAAAAAAA/9oADAMBAAIQAxAAAAH1SAAAAAAAAAAACAOGgAAAAxIpjRwAAARh0sgAAAAAAAAAAAf/xAAeEAACAQQDAQAAAAAAAAAAAAAEBQYDBzBAARQVJf/aAAgBAQABBQLYpPyBpUqkBDt/guR9Pi35AtWMYEsc81gPHelI9j//xAAUEQEAAAAAAAAAAAAAAAAAAABg/9oACAEDAQE/AQ3/xAAUEQEAAAAAAAAAAAAAAAAAAABg/9oACAECAQE/AQ3/xAAnEAAABAQEBwEAAAAAAAAAAAABAgMEBRESIQATMTIUFSMwQEFRsf/aAAgBAQAGPwLyFIS/ImRNcmYxWIAhXLcUb7gw7SaET5S06Z3AgNSivwt9A7LCEsiZkZUUzkDFNSKABqcR9fMNkmyXDmb9FdEdxFQ3T/ey+iDhxxj52a6tFNBPRACY2wvE2zjKSckk4bUWOYNDznYfJ//EACAQAAIBAwUBAQAAAAAAAAAAAAEhQQARUTAxQHGhkdH/2gAIAQEAAT8h5CyVJGTLIrKGKIIvklnTIbH3RG+oCDDDYfrsCnTH+mAT60ZqsLIcUB21ikOG624gEUbvPJ//2gAMAwEAAgADAAAAEJJJJJJJJJJJJBJJJJIJJJJBJJJJJJJJJJJJP//EABQRAQAAAAAAAAAAAAAAAAAAAGD/2gAIAQMBAT8QDf/EABQRAQAAAAAAAAAAAAAAAAAAAGD/2gAIAQIBAT8QDf/EAB4QAQEBAAEEAwAAAAAAAAAAAAERITEAMEBBUWFx/9oACAEBAAE/EPInI4VM4a/QEWIdB8h5ykkE0tRkwp2ERvq2fMhCDK0olS/v4H91bT6PEh2MOV4VtZINdMTtdfM5f5ShJQkFMaPI/9k=~, '40.32.48.16' ],
        ],
        tga => [
            [ qq~AAEJAAABASAAAAAAUAAyAAgAAAAA/wEBAf8CAgL/AwMD/wQEBP8FBQX/BgYG/wcHB/8ICAj/CQkJ/woKCv8LCwv/DAwM/w0NDf8ODg7/Dw8P/xAQEP8RERH/EhIS/xMTE/8UFBT/FRUV/xYWFv8XFxf/GBgY/xkZGf8aGhr/Gxsb/xwcHP8dHR3/Hh4e/x8fH/8gICD/ISEh/yIiIv8jIyP/JCQk/yUlJf8mJib/Jycn/ygoKP8pKSn/Kioq/ysrK/8sLCz/LS0t/y4uLv8vLy//MDAw/zExMf8yMjL/MzMz/zQ0NP81NTX/NjY2/zc3N/84ODj/OTk5/zo6Ov87Ozv/PDw8/z09Pf8+Pj7/Pz8//0BAQP9BQUH/QkJC/0NDQ/9ERET/RUVF/0ZGRv9HR0f/SEhI/0lJSf9KSkr/S0tL/0xMTP9NTU3/Tk5O/09PT/9QUFD/UVFR/1JSUv9TU1P/VFRU/1VVVf9WVlb/V1dX/1hYWP9ZWVn/Wlpa/1tbW/9cXFz/XV1d/15eXv9fX1//YGBg/2FhYf9iYmL/Y2Nj/2RkZP9lZWX/ZmZm/2dnZ/9oaGj/aWlp/2pqav9ra2v/bGxs/21tbf9ubm7/b29v/3BwcP9xcXH/cnJy/3Nzc/90dHT/dXV1/3Z2dv93d3f/eHh4/3l5ef96enr/e3t7/3x8fP99fX3/fn5+/39/f/+AgID/gYGB/4KCgv+Dg4P/hISE/4WFhf+Ghob/h4eH/4iIiP+JiYn/ioqK/4uLi/+MjIz/jY2N/46Ojv+Pj4//kJCQ/5GRkf+SkpL/k5OT/5SUlP+VlZX/lpaW/5eXl/+YmJj/mZmZ/5qamv+bm5v/nJyc/52dnf+enp7/n5+f/6CgoP+hoaH/oqKi/6Ojo/+kpKT/paWl/6ampv+np6f/qKio/6mpqf+qqqr/q6ur/6ysrP+tra3/rq6u/6+vr/+wsLD/sbGx/7Kysv+zs7P/tLS0/7W1tf+2trb/t7e3/7i4uP+5ubn/urq6/7u7u/+8vLz/vb29/76+vv+/v7//wMDA/8HBwf/CwsL/w8PD/8TExP/FxcX/xsbG/8fHx//IyMj/ycnJ/8rKyv/Ly8v/zMzM/83Nzf/Ozs7/z8/P/9DQ0P/R0dH/0tLS/9PT0//U1NT/1dXV/9bW1v/X19f/2NjY/9nZ2f/a2tr/29vb/9zc3P/d3d3/3t7e/9/f3//g4OD/4eHh/+Li4v/j4+P/5OTk/+Xl5f/m5ub/5+fn/+jo6P/p6en/6urq/+vr6//s7Oz/7e3t/+7u7v/v7+//8PDw//Hx8f/y8vL/8/Pz//T09P/19fX/9vb2//f39//4+Pj/+fn5//r6+v/7+/v//Pz8//39/f/+/v7//////wAAAADP/8//z//P/8//z//P/8//z//P/8//z//P/8//z//P/8//z/+g/wNWAD7+hv8CVwBPoP+g/wPsGACOhf8DtgAM46D/of8DtAAI14P/A/UgAI+h/6L/A2IANfyC/wN2ADL8of+i/wPyHwCDgf8D0QQCy6L/o/8HvwEFz/04AG2j/6T/Bm4ALY8AG/Kj/6T/AfYnggAArKT/pf8DyQIASqX/pf8As4EAASX1pP+k/wX0HwANAGyk/6T/BnIAMM4GAb2j/6P/CM4DAsr/hwAf8aL/ov8D/DQAbIH/A/w5AGKi/6L/A5AAG/GC/wPbCgCzof+h/wPjDQCshP8DlAAY7aD/of8CTwBMhf8D/kUAV6D/z//P/8//z//P/8//z//P/8//z//P/8//z//P/8//AAAAAAAAAABUUlVFVklTSU9OLVhGSUxFLgA=~, '32.33.47.15' ],
            [ qq~AAEJAAABASAAAAAAUAAyAAgAAAAA/wEBAf8CAgL/AwMD/wQEBP8FBQX/BgYG/wcHB/8ICAj/CQkJ/woKCv8LCwv/DAwM/w0NDf8ODg7/Dw8P/xAQEP8RERH/EhIS/xMTE/8UFBT/FRUV/xYWFv8XFxf/GBgY/xkZGf8aGhr/Gxsb/xwcHP8dHR3/Hh4e/x8fH/8gICD/ISEh/yIiIv8jIyP/JCQk/yUlJf8mJib/Jycn/ygoKP8pKSn/Kioq/ysrK/8sLCz/LS0t/y4uLv8vLy//MDAw/zExMf8yMjL/MzMz/zQ0NP81NTX/NjY2/zc3N/84ODj/OTk5/zo6Ov87Ozv/PDw8/z09Pf8+Pj7/Pz8//0BAQP9BQUH/QkJC/0NDQ/9ERET/RUVF/0ZGRv9HR0f/SEhI/0lJSf9KSkr/S0tL/0xMTP9NTU3/Tk5O/09PT/9QUFD/UVFR/1JSUv9TU1P/VFRU/1VVVf9WVlb/V1dX/1hYWP9ZWVn/Wlpa/1tbW/9cXFz/XV1d/15eXv9fX1//YGBg/2FhYf9iYmL/Y2Nj/2RkZP9lZWX/ZmZm/2dnZ/9oaGj/aWlp/2pqav9ra2v/bGxs/21tbf9ubm7/b29v/3BwcP9xcXH/cnJy/3Nzc/90dHT/dXV1/3Z2dv93d3f/eHh4/3l5ef96enr/e3t7/3x8fP99fX3/fn5+/39/f/+AgID/gYGB/4KCgv+Dg4P/hISE/4WFhf+Ghob/h4eH/4iIiP+JiYn/ioqK/4uLi/+MjIz/jY2N/46Ojv+Pj4//kJCQ/5GRkf+SkpL/k5OT/5SUlP+VlZX/lpaW/5eXl/+YmJj/mZmZ/5qamv+bm5v/nJyc/52dnf+enp7/n5+f/6CgoP+hoaH/oqKi/6Ojo/+kpKT/paWl/6ampv+np6f/qKio/6mpqf+qqqr/q6ur/6ysrP+tra3/rq6u/6+vr/+wsLD/sbGx/7Kysv+zs7P/tLS0/7W1tf+2trb/t7e3/7i4uP+5ubn/urq6/7u7u/+8vLz/vb29/76+vv+/v7//wMDA/8HBwf/CwsL/w8PD/8TExP/FxcX/xsbG/8fHx//IyMj/ycnJ/8rKyv/Ly8v/zMzM/83Nzf/Ozs7/z8/P/9DQ0P/R0dH/0tLS/9PT0//U1NT/1dXV/9bW1v/X19f/2NjY/9nZ2f/a2tr/29vb/9zc3P/d3d3/3t7e/9/f3//g4OD/4eHh/+Li4v/j4+P/5OTk/+Xl5f/m5ub/5+fn/+jo6P/p6en/6urq/+vr6//s7Oz/7e3t/+7u7v/v7+//8PDw//Hx8f/y8vL/8/Pz//T09P/19fX/9vb2//f39//4+Pj/+fn5//r6+v/7+/v//Pz8//39/f/+/v7//////wAAAADP/8//z//P/8//z//P/8//z//P/8//z//P/8//z//P/8//z/+g/wNWAD7+hv8CVwBPoP+g/wPsGACOhf8DtgAM46D/of8DtAAI14P/A/UgAI+h/6L/A2IANfyC/wN2ADL8of+i/wPyHwCDgf8D0QQCy6L/o/8HvwEFz/04AG2j/6T/Bm4ALY8AG/Kj/6T/AfYnggAArKT/pf8DyQIASqX/pf8As4EAASX1pP+k/wX0HwANAGyk/6T/BnIAMM4GAb2j/6P/CM4DAsr/hwAf8aL/ov8D/DQAbIH/A/w5AGKi/6L/A5AAG/GC/wPbCgCzof+h/wPjDQCshP8DlAAY7aD/of8CTwBMhf8D/kUAV6D/z//P/8//z//P/8//z//P/8//z//P/8//z//P/8//AAAAAAAAAABUUlVFVklTSU9OLVhGSUxFLgA=~, '32.33.47.15' ],
        ],
    }; 

    foreach my $type (keys %{$images}) {
         foreach my $img (@{$images->{$type}}) {
             $img->[0] = decode_base64($img->[0]);
         }
    }

    return $images;
}
